"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSelectedDataStreamHidden = exports.isFleetManaged = exports.filterDataStreams = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isFleetManaged = dataStream => {
  var _dataStream$_meta, _dataStream$_meta2;
  // TODO check if the wording will change to 'fleet'
  return Boolean(((_dataStream$_meta = dataStream._meta) === null || _dataStream$_meta === void 0 ? void 0 : _dataStream$_meta.managed) && ((_dataStream$_meta2 = dataStream._meta) === null || _dataStream$_meta2 === void 0 ? void 0 : _dataStream$_meta2.managed_by) === 'ingest-manager');
};
exports.isFleetManaged = isFleetManaged;
const filterDataStreams = (dataStreams, visibleTypes) => {
  return dataStreams.filter(dataStream => {
    // include all data streams that are neither hidden nor managed
    if (!dataStream.hidden && !isFleetManaged(dataStream)) {
      return true;
    }
    if (dataStream.hidden && visibleTypes.includes('hidden')) {
      return true;
    }
    return isFleetManaged(dataStream) && visibleTypes.includes('managed');
  });
};
exports.filterDataStreams = filterDataStreams;
const isSelectedDataStreamHidden = (dataStreams, selectedDataStreamName) => {
  var _dataStreams$find;
  return !!selectedDataStreamName && !!((_dataStreams$find = dataStreams.find(dataStream => dataStream.name === selectedDataStreamName)) !== null && _dataStreams$find !== void 0 && _dataStreams$find.hidden);
};
exports.isSelectedDataStreamHidden = isSelectedDataStreamHidden;