"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldBetaBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldBetaBadge = () => {
  const betaText = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fieldBetaBadgeLabel', {
    defaultMessage: 'Beta'
  });
  const tooltipText = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fieldBetaBadgeTooltip', {
    defaultMessage: 'This field type is not GA. Please help us by reporting any bugs.'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: betaText,
    tooltipContent: tooltipText
  });
};
exports.FieldBetaBadge = FieldBetaBadge;