"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MappingsDatastreamRolloverModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../../../services/documentation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MappingsDatastreamRolloverModal = ({
  componentTemplatename,
  dataStreams,
  onClose,
  api
}) => {
  const [error, setError] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const onConfirm = (0, _react.useCallback)(() => {
    async function confirm() {
      try {
        setIsLoading(true);
        for (const dataStream of dataStreams) {
          await api.postDataStreamRollover(dataStream);
        }
        await onClose();
      } catch (err) {
        setError(err);
      } finally {
        setIsLoading(false);
      }
    }
    confirm();
  }, [api, onClose, dataStreams]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "mappingDatastreamRolloverModal",
    isLoading: isLoading,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateEdit.mappingRolloverModalTitle",
      defaultMessage: "Apply mappings now and rollover?"
    }),
    onCancel: onClose,
    onConfirm: onConfirm,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateMappingsRollover.cancelButton",
      defaultMessage: "Apply on next rollover"
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateMappingsRollover.confirmButtom",
      defaultMessage: "Apply now and rollover"
    })
  }, error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateMappingsRollover.saveError",
      defaultMessage: "Unable to apply rollover"
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "applyMappingsRolloverError"
  }, /*#__PURE__*/_react.default.createElement("div", null, error.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateMappingsRollover.modalDescription",
    defaultMessage: "New mappings for the {templateName} component template require a rollover for the following data streams: {datastreams} You can apply the new mappings to incoming data now and force a rollover, or wait until the next rollover. Rollover timing is defined by your index lifecycle policy. {moreInfoLink}",
    values: {
      templateName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, componentTemplatename),
      moreInfoLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: _documentation.documentationService.docLinks.fleet.datastreamsILM
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateEdit.moreInfoLink",
        defaultMessage: "See the documentation for more info."
      })),
      datastreams: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement("ul", null, dataStreams.map(dataStream => /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, dataStream)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }))
    }
  })));
};
exports.MappingsDatastreamRolloverModal = MappingsDatastreamRolloverModal;