"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDelete = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _notification = require("../../../services/notification");
var _api_errors = require("../../../services/api_errors");
var _api = require("../../../services/api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConfirmDelete extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isDeleteConfirmed: false
    });
    (0, _defineProperty2.default)(this, "setIsDeleteConfirmed", confirmed => {
      this.setState({
        isDeleteConfirmed: confirmed
      });
    });
    (0, _defineProperty2.default)(this, "deletePolicy", async () => {
      const {
        policyToDelete,
        callback
      } = this.props;
      const policyName = policyToDelete.name;
      try {
        await (0, _api.deletePolicy)(policyName);
        const message = _i18n.i18n.translate('xpack.indexLifecycleMgmt.confirmDelete.successMessage', {
          defaultMessage: 'Deleted policy {policyName}',
          values: {
            policyName
          }
        });
        _notification.toasts.addSuccess(message);
      } catch (e) {
        const title = _i18n.i18n.translate('xpack.indexLifecycleMgmt.confirmDelete.errorMessage', {
          defaultMessage: 'Error deleting policy {policyName}',
          values: {
            policyName
          }
        });
        (0, _api_errors.showApiError)(e, title);
      }
      if (callback) {
        callback();
      }
    });
    (0, _defineProperty2.default)(this, "isPolicyPolicy", true);
  }
  render() {
    var _policyToDelete$polic, _policyToDelete$polic2;
    const {
      policyToDelete,
      onCancel
    } = this.props;
    const {
      isDeleteConfirmed
    } = this.state;
    const isManagedPolicy = (_policyToDelete$polic = policyToDelete.policy) === null || _policyToDelete$polic === void 0 ? void 0 : (_policyToDelete$polic2 = _policyToDelete$polic._meta) === null || _policyToDelete$polic2 === void 0 ? void 0 : _policyToDelete$polic2.managed;
    const title = _i18n.i18n.translate('xpack.indexLifecycleMgmt.confirmDelete.title', {
      defaultMessage: 'Delete policy "{name}"',
      values: {
        name: policyToDelete.name
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "data-test-subj": "deletePolicyModal",
      title: title,
      onCancel: onCancel,
      onConfirm: this.deletePolicy,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.confirmDelete.cancelButton",
        defaultMessage: "Cancel"
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.confirmDelete.deleteButton",
        defaultMessage: "Delete"
      }),
      buttonColor: "danger",
      confirmButtonDisabled: isManagedPolicy ? !isDeleteConfirmed : false
    }, isManagedPolicy ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.deletePolicyModal.proceedWithCautionCallOutTitle",
        defaultMessage: "Deleting a managed policy can break Kibana"
      }),
      color: "danger",
      iconType: "warning",
      "data-test-subj": "deleteManagedPolicyCallOut"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.deletePolicyModal.proceedWithCautionCallOutDescription",
      defaultMessage: "Managed policies are critical for internal operations. If you delete this managed policy, you can\u2019t recover it."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: "confirmDeletePolicyCheckbox",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.deletePolicyModal.confirmDeleteCheckboxLabel",
        defaultMessage: "I understand the consequences of deleting a managed policy"
      }),
      checked: isDeleteConfirmed,
      onChange: e => this.setIsDeleteConfirmed(e.target.checked)
    })) : /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.confirmDelete.undoneWarning",
      defaultMessage: "You can't recover a deleted policy."
    })));
  }
}
exports.ConfirmDelete = ConfirmDelete;