"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DescribedFormRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DescribedFormRow = ({
  children,
  switchProps,
  description,
  fieldNotices,
  ...restDescribedFormProps
}) => {
  var _switchProps$checked;
  if (switchProps && !(typeof switchProps.checked === 'boolean' || typeof switchProps.initialValue === 'boolean')) {
    throw new Error('Must specify controlled, uncontrolled component. See SwitchProps interface!');
  }
  const [uncontrolledIsContentVisible, setUncontrolledIsContentVisible] = (0, _react.useState)(() => {
    var _switchProps$initialV;
    return (_switchProps$initialV = switchProps === null || switchProps === void 0 ? void 0 : switchProps.initialValue) !== null && _switchProps$initialV !== void 0 ? _switchProps$initialV : false;
  });
  const isContentVisible = Boolean(switchProps === undefined || ((_switchProps$checked = switchProps === null || switchProps === void 0 ? void 0 : switchProps.checked) !== null && _switchProps$checked !== void 0 ? _switchProps$checked : uncontrolledIsContentVisible));
  const renderToggle = () => {
    if (!switchProps) {
      return null;
    }
    const {
      onChange,
      checked,
      initialValue,
      ...restSwitchProps
    } = switchProps;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({}, restSwitchProps, {
      checked: isContentVisible,
      onChange: e => {
        const nextValue = e.target.checked;
        setUncontrolledIsContentVisible(nextValue);
        if (onChange) {
          onChange(nextValue);
        }
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, (0, _extends2.default)({}, restDescribedFormProps, {
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, description, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), renderToggle(), fieldNotices)
  }), isContentVisible ? typeof children === 'function' ? children() : children : null);
};
exports.DescribedFormRow = DescribedFormRow;