"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.I18nProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactIntl = require("react-intl");
var _i18n = require("@kbn/i18n");
var _pseudo_locale_wrapper = require("./pseudo_locale_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// eslint-disable-next-line @kbn/eslint/module_migration

/**
 * The library uses the provider pattern to scope an i18n context to a tree
 * of components. This component is used to setup the i18n context for a tree.
 * IntlProvider should wrap react app's root component (inside each react render method).
 */

const I18nProvider = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_reactIntl.IntlProvider, {
  locale: _i18n.i18n.getLocale(),
  messages: _i18n.i18n.getTranslation().messages,
  defaultLocale: _i18n.i18n.getDefaultLocale(),
  formats: _i18n.i18n.getFormats(),
  textComponent: _react.default.Fragment
}, /*#__PURE__*/_react.default.createElement(_pseudo_locale_wrapper.PseudoLocaleWrapper, null, children));
exports.I18nProvider = I18nProvider;