"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureCatalogueRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @public */

/** @public */

/** @public */

class FeatureCatalogueRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "capabilities", null);
    (0, _defineProperty2.default)(this, "features", new Map());
    (0, _defineProperty2.default)(this, "solutions", new Map());
  }
  setup() {
    return {
      register: feature => {
        if (this.features.has(feature.id)) {
          throw new Error(`Feature with id [${feature.id}] has already been registered. Use a unique id.`);
        }
        this.features.set(feature.id, feature);
      },
      registerSolution: solution => {
        if (this.solutions.has(solution.id)) {
          throw new Error(`Solution with id [${solution.id}] has already been registered. Use a unique id.`);
        }
        this.solutions.set(solution.id, solution);
      }
    };
  }
  start({
    capabilities
  }) {
    this.capabilities = capabilities;
  }
  get() {
    if (this.capabilities === null) {
      throw new Error('Catalogue entries are only available after start phase');
    }
    const capabilities = this.capabilities;
    return [...this.features.values()].filter(entry => capabilities.catalogue[entry.id] !== false && (entry.visible ? entry.visible() : true)).sort(compareByKey('title'));
  }
  getSolutions() {
    if (this.capabilities === null) {
      throw new Error('Catalogue entries are only available after start phase');
    }
    const capabilities = this.capabilities;
    return [...this.solutions.values()].filter(solution => capabilities.catalogue[solution.id] !== false).sort(compareByKey('title'));
  }
  removeFeature(appId) {
    this.features.delete(appId);
  }
}
exports.FeatureCatalogueRegistry = FeatureCatalogueRegistry;
const compareByKey = key => (left, right) => {
  if (left[key] < right[key]) {
    return -1;
  } else if (left[key] > right[key]) {
    return 1;
  } else {
    return 0;
  }
};