"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HomePublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _constants = require("../common/constants");
var _kibana_services = require("./application/kibana_services");
var _services = require("./services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class HomePublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "featuresCatalogueRegistry", new _services.FeatureCatalogueRegistry());
    (0, _defineProperty2.default)(this, "environmentService", new _services.EnvironmentService());
    (0, _defineProperty2.default)(this, "tutorialService", new _services.TutorialService());
    (0, _defineProperty2.default)(this, "addDataService", new _services.AddDataService());
    (0, _defineProperty2.default)(this, "welcomeService", new _services.WelcomeService());
    this.initializerContext = initializerContext;
  }
  setup(core, {
    cloud,
    share,
    urlForwarding,
    usageCollection
  }) {
    core.application.register({
      id: _constants.PLUGIN_ID,
      title: 'Home',
      navLinkStatus: _public.AppNavLinkStatus.hidden,
      mount: async params => {
        const trackUiMetric = usageCollection ? usageCollection.reportUiCounter.bind(usageCollection, 'Kibana_home') : () => {};
        const [coreStart, {
          dataViews,
          urlForwarding: urlForwardingStart,
          guidedOnboarding,
          cloudChatProvider
        }] = await core.getStartServices();
        (0, _kibana_services.setServices)({
          share,
          trackUiMetric,
          kibanaVersion: this.initializerContext.env.packageInfo.version,
          http: coreStart.http,
          toastNotifications: coreStart.notifications.toasts,
          banners: coreStart.overlays.banners,
          docLinks: coreStart.docLinks,
          savedObjectsClient: coreStart.savedObjects.client,
          chrome: coreStart.chrome,
          application: coreStart.application,
          uiSettings: core.uiSettings,
          addBasePath: core.http.basePath.prepend,
          getBasePath: core.http.basePath.get,
          dataViewsService: dataViews,
          environmentService: this.environmentService,
          urlForwarding: urlForwardingStart,
          homeConfig: this.initializerContext.config.get(),
          tutorialService: this.tutorialService,
          addDataService: this.addDataService,
          featureCatalogue: this.featuresCatalogueRegistry,
          welcomeService: this.welcomeService,
          guidedOnboardingService: guidedOnboarding.guidedOnboardingApi,
          cloud,
          cloudChat: cloudChatProvider
        });
        coreStart.chrome.docTitle.change(_i18n.i18n.translate('home.pageTitle', {
          defaultMessage: 'Home'
        }));
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        return await renderApp(params.element, params.theme$, coreStart, params.history);
      }
    });
    urlForwarding.forwardApp('home', 'home');
    const featureCatalogue = {
      ...this.featuresCatalogueRegistry.setup()
    };
    featureCatalogue.register({
      id: 'home_tutorial_directory',
      title: _i18n.i18n.translate('home.tutorialDirectory.featureCatalogueTitle', {
        defaultMessage: 'Add data'
      }),
      description: _i18n.i18n.translate('home.tutorialDirectory.featureCatalogueDescription', {
        defaultMessage: 'Ingest data from popular apps and services.'
      }),
      icon: 'indexOpen',
      showOnHomePage: true,
      path: `${_constants.HOME_APP_BASE_PATH}#/tutorial_directory`,
      category: 'data',
      order: 500
    });
    const environment = {
      ...this.environmentService.setup()
    };
    const tutorials = {
      ...this.tutorialService.setup()
    };
    if (cloud) {
      environment.update({
        cloud: cloud.isCloudEnabled
      });
      if (cloud.isCloudEnabled) {
        var _cloud$profileUrl, _cloud$baseUrl, _cloud$deploymentUrl, _cloud$baseUrl2;
        tutorials.setVariable('cloud', {
          id: cloud.cloudId,
          baseUrl: cloud.baseUrl,
          // Cloud's API already provides the full URLs
          profileUrl: (_cloud$profileUrl = cloud.profileUrl) === null || _cloud$profileUrl === void 0 ? void 0 : _cloud$profileUrl.replace((_cloud$baseUrl = cloud.baseUrl) !== null && _cloud$baseUrl !== void 0 ? _cloud$baseUrl : '', ''),
          deploymentUrl: (_cloud$deploymentUrl = cloud.deploymentUrl) === null || _cloud$deploymentUrl === void 0 ? void 0 : _cloud$deploymentUrl.replace((_cloud$baseUrl2 = cloud.baseUrl) !== null && _cloud$baseUrl2 !== void 0 ? _cloud$baseUrl2 : '', '')
        });
      }
    }
    return {
      featureCatalogue,
      environment,
      tutorials,
      addData: {
        ...this.addDataService.setup()
      },
      welcomeScreen: {
        ...this.welcomeService.setup()
      }
    };
  }
  start({
    application: {
      capabilities
    }
  }) {
    this.featuresCatalogueRegistry.start({
      capabilities
    });
    return {
      featureCatalogue: this.featuresCatalogueRegistry
    };
  }
}

/** @public */
exports.HomePublicPlugin = HomePublicPlugin;