"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrillDownIconLinks = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DrillDownIconLinks = ({
  hasNodes,
  urlTemplates,
  openUrlTemplate
}) => {
  const drillDownsWithIcons = urlTemplates.filter(({
    icon
  }) => icon && icon.class !== '');
  if (drillDownsWithIcons.length === 0) {
    return null;
  }
  const drillDowns = drillDownsWithIcons.map(cur => {
    var _cur$icon;
    const onUrlTemplateClick = () => openUrlTemplate(cur);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: cur.description
    }, /*#__PURE__*/_react.default.createElement("button", {
      className: "kuiButton kuiButton--basic kuiButton--small",
      type: "button",
      disabled: hasNodes,
      onClick: onUrlTemplateClick
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: `kuiIcon ${((_cur$icon = cur.icon) === null || _cur$icon === void 0 ? void 0 : _cur$icon.class) || ''}`
    }))));
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "gphDrillDownIconLinks",
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, drillDowns);
};
exports.DrillDownIconLinks = DrillDownIconLinks;