"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.i18nStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nStrings = {
  placeholderText: _i18n.i18n.translate('xpack.globalSearchBar.searchBar.placeholder', {
    defaultMessage: 'Find apps, content, and more.'
  }),
  popoverButton: _i18n.i18n.translate('xpack.globalSearchBar.searchBar.mobileSearchButtonAriaLabel', {
    defaultMessage: 'Site-wide search'
  }),
  showSearchAriaText: _i18n.i18n.translate('xpack.globalSearchBar.searchBar.showSearchAriaText', {
    defaultMessage: 'Show search bar'
  }),
  closeSearchAriaText: _i18n.i18n.translate('xpack.globalSearchBar.searchBar.closeSearchAriaText', {
    defaultMessage: 'Close search bar'
  }),
  keyboardShortcutTooltip: {
    prefix: _i18n.i18n.translate('xpack.globalSearchBar.searchBar.shortcutTooltip.description', {
      defaultMessage: 'Keyboard shortcut'
    }),
    onMac: _i18n.i18n.translate('xpack.globalSearchBar.searchBar.shortcutTooltip.macCommandDescription', {
      defaultMessage: 'Command + /'
    }),
    onNotMac: _i18n.i18n.translate('xpack.globalSearchBar.searchBar.shortcutTooltip.windowsCommandDescription', {
      defaultMessage: 'Control + /'
    })
  }
};
exports.i18nStrings = i18nStrings;