"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCloudFormationTemplateUrlFromPackagePolicy = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get the cloud formation template url from a package policy
 * It looks for a config with a cloud_formation_template_url object present in
 * the enabled inputs of the package policy
 */
const getCloudFormationTemplateUrlFromPackagePolicy = packagePolicy => {
  var _packagePolicy$inputs;
  const cloudFormationTemplateUrl = packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$inputs = packagePolicy.inputs) === null || _packagePolicy$inputs === void 0 ? void 0 : _packagePolicy$inputs.reduce((accInput, input) => {
    var _input$config;
    if (accInput !== '') {
      return accInput;
    }
    if (input !== null && input !== void 0 && input.enabled && input !== null && input !== void 0 && (_input$config = input.config) !== null && _input$config !== void 0 && _input$config.cloud_formation_template_url) {
      return input.config.cloud_formation_template_url.value;
    }
    return accInput;
  }, '');
  return cloudFormationTemplateUrl !== '' ? cloudFormationTemplateUrl : undefined;
};
exports.getCloudFormationTemplateUrlFromPackagePolicy = getCloudFormationTemplateUrlFromPackagePolicy;