"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateNewAgentPolicyWithDefaults = generateNewAgentPolicyWithDefaults;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TWO_WEEKS_SECONDS = 1209600;
// create a new agent policy with the defaults set
// used by forms which create new agent policies for initial state value
function generateNewAgentPolicyWithDefaults(overrideProps = {}) {
  return {
    name: '',
    description: '',
    namespace: 'default',
    monitoring_enabled: Object.values(_constants.dataTypes),
    inactivity_timeout: TWO_WEEKS_SECONDS,
    ...overrideProps
  };
}