"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendDeleteOutput = sendDeleteOutput;
exports.sendPostLogstashApiKeys = sendPostLogstashApiKeys;
exports.sendPostOutput = sendPostOutput;
exports.sendPutOutput = sendPutOutput;
exports.useDefaultOutput = useDefaultOutput;
exports.useGetOutputs = useGetOutputs;
var _services = require("../../services");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetOutputs() {
  return (0, _use_request.useRequest)({
    method: 'get',
    path: _services.outputRoutesService.getListPath()
  });
}
function useDefaultOutput() {
  var _outputsRequest$data;
  const outputsRequest = useGetOutputs();
  const output = (_outputsRequest$data = outputsRequest.data) === null || _outputsRequest$data === void 0 ? void 0 : _outputsRequest$data.items.find(o => o.is_default);
  return {
    output,
    refresh: outputsRequest.resendRequest
  };
}
function sendPutOutput(outputId, body) {
  return (0, _use_request.sendRequest)({
    method: 'put',
    path: _services.outputRoutesService.getUpdatePath(outputId),
    body
  });
}
function sendPostLogstashApiKeys() {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.outputRoutesService.getCreateLogstashApiKeyPath()
  });
}
function sendPostOutput(body) {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.outputRoutesService.getCreatePath(),
    body
  });
}
function sendDeleteOutput(outputId) {
  return (0, _use_request.sendRequest)({
    method: 'delete',
    path: _services.outputRoutesService.getDeletePath(outputId)
  });
}