"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendUpdatePackage = exports.sendRequestReauthorizeTransforms = exports.sendRemovePackage = exports.sendInstallPackage = exports.sendGetPackages = exports.sendGetPackageInfoByKey = exports.sendGetFileByPath = exports.sendGetCategories = exports.sendGetBulkAssets = exports.sendBulkInstallPackages = void 0;
exports.useGetAppendCustomIntegrations = useGetAppendCustomIntegrations;
exports.useGetCategoriesQuery = useGetCategoriesQuery;
exports.useGetPackagesQuery = exports.useGetPackages = exports.useGetPackageVerificationKeyId = exports.useGetPackageStats = exports.useGetPackageInfoByKeyQuery = exports.useGetLimitedPackages = exports.useGetFileByPathQuery = exports.useGetFileByPath = void 0;
exports.useGetReplacementCustomIntegrations = useGetReplacementCustomIntegrations;
exports.useUpdatePackageMutation = void 0;
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _reactQuery = require("@tanstack/react-query");
var _react = require("react");
var _services = require("../../services");
var _custom_integrations = require("../../services/custom_integrations");
var _use_confirm_open_unverified = require("../../applications/integrations/hooks/use_confirm_open_unverified");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetAppendCustomIntegrations() {
  const customIntegrations = (0, _custom_integrations.getCustomIntegrations)();
  return (0, _useAsync.default)(customIntegrations.getAppendCustomIntegrations, []);
}
function useGetReplacementCustomIntegrations() {
  const customIntegrations = (0, _custom_integrations.getCustomIntegrations)();
  return (0, _useAsync.default)(customIntegrations.getReplacementCustomIntegrations, []);
}
function useGetCategoriesQuery(query = {}) {
  return (0, _reactQuery.useQuery)(['categories', query], () => (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getCategoriesPath(),
    method: 'get',
    query
  }));
}
const sendGetCategories = (query = {}) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getCategoriesPath(),
    method: 'get',
    query
  });
};
exports.sendGetCategories = sendGetCategories;
const useGetPackages = (query = {}) => {
  return (0, _use_request.useRequest)({
    path: _services.epmRouteService.getListPath(),
    method: 'get',
    query
  });
};
exports.useGetPackages = useGetPackages;
const useGetPackagesQuery = query => {
  return (0, _reactQuery.useQuery)(['get-packages', query], () => (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getListPath(),
    method: 'get',
    query
  }));
};
exports.useGetPackagesQuery = useGetPackagesQuery;
const sendGetPackages = (query = {}) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getListPath(),
    method: 'get',
    query
  });
};
exports.sendGetPackages = sendGetPackages;
const useGetLimitedPackages = () => {
  return (0, _use_request.useRequest)({
    path: _services.epmRouteService.getListLimitedPath(),
    method: 'get'
  });
};
exports.useGetLimitedPackages = useGetLimitedPackages;
const useGetPackageInfoByKeyQuery = (pkgName, pkgVersion, options) => {
  const confirmOpenUnverified = (0, _use_confirm_open_unverified.useConfirmOpenUnverified)();
  const [ignoreUnverifiedQueryParam, setIgnoreUnverifiedQueryParam] = (0, _react.useState)(options === null || options === void 0 ? void 0 : options.ignoreUnverified);
  const response = (0, _reactQuery.useQuery)([pkgName, pkgVersion, options], () => (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getInfoPath(pkgName, pkgVersion),
    method: 'get',
    query: {
      ...options,
      ...(ignoreUnverifiedQueryParam && {
        ignoreUnverified: ignoreUnverifiedQueryParam
      })
    }
  }));
  const confirm = async () => {
    const forceInstall = await confirmOpenUnverified(pkgName);
    if (forceInstall) {
      setIgnoreUnverifiedQueryParam(true);
    }
  };
  if (response !== null && response !== void 0 && response.error && (0, _services.isVerificationError)(response === null || response === void 0 ? void 0 : response.error)) {
    confirm();
  }
  return response;
};
exports.useGetPackageInfoByKeyQuery = useGetPackageInfoByKeyQuery;
const useGetPackageStats = pkgName => {
  return (0, _use_request.useRequest)({
    path: _services.epmRouteService.getStatsPath(pkgName),
    method: 'get'
  });
};
exports.useGetPackageStats = useGetPackageStats;
const useGetPackageVerificationKeyId = () => {
  const {
    data,
    ...rest
  } = (0, _reactQuery.useQuery)(['verification_key_id'], () => (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getVerificationKeyIdPath(),
    method: 'get'
  }));
  return {
    packageVerificationKeyId: (data === null || data === void 0 ? void 0 : data.id) || undefined,
    ...rest
  };
};
exports.useGetPackageVerificationKeyId = useGetPackageVerificationKeyId;
const sendGetPackageInfoByKey = (pkgName, pkgVersion, options) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getInfoPath(pkgName, pkgVersion),
    method: 'get',
    query: options
  });
};
exports.sendGetPackageInfoByKey = sendGetPackageInfoByKey;
const useGetFileByPath = filePath => {
  return (0, _use_request.useRequest)({
    path: _services.epmRouteService.getFilePath(filePath),
    method: 'get'
  });
};
exports.useGetFileByPath = useGetFileByPath;
const useGetFileByPathQuery = filePath => {
  return (0, _reactQuery.useQuery)(['get-file', filePath], () => (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getFilePath(filePath),
    method: 'get'
  }));
};
exports.useGetFileByPathQuery = useGetFileByPathQuery;
const sendGetFileByPath = filePath => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getFilePath(filePath),
    method: 'get'
  });
};
exports.sendGetFileByPath = sendGetFileByPath;
const sendInstallPackage = (pkgName, pkgVersion, force = false) => {
  const body = force ? {
    force
  } : undefined;
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getInstallPath(pkgName, pkgVersion),
    method: 'post',
    body
  });
};
exports.sendInstallPackage = sendInstallPackage;
const sendBulkInstallPackages = packages => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getBulkInstallPath(),
    method: 'post',
    body: {
      packages
    }
  });
};
exports.sendBulkInstallPackages = sendBulkInstallPackages;
const sendRemovePackage = (pkgName, pkgVersion, force = false) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getRemovePath(pkgName, pkgVersion),
    method: 'delete',
    body: {
      force
    }
  });
};
exports.sendRemovePackage = sendRemovePackage;
const sendRequestReauthorizeTransforms = (pkgName, pkgVersion, transforms) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getReauthorizeTransformsPath(pkgName, pkgVersion),
    method: 'post',
    body: {
      transforms
    }
  });
};
exports.sendRequestReauthorizeTransforms = sendRequestReauthorizeTransforms;
const useUpdatePackageMutation = () => {
  return (0, _reactQuery.useMutation)(({
    pkgName,
    pkgVersion,
    body
  }) => (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getUpdatePath(pkgName, pkgVersion),
    method: 'put',
    body
  }));
};
exports.useUpdatePackageMutation = useUpdatePackageMutation;
const sendUpdatePackage = (pkgName, pkgVersion, body) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getUpdatePath(pkgName, pkgVersion),
    method: 'put',
    body
  });
};
exports.sendUpdatePackage = sendUpdatePackage;
const sendGetBulkAssets = body => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getBulkAssetsPath(),
    method: 'post',
    body
  });
};
exports.sendGetBulkAssets = sendGetBulkAssets;