"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateCloudFormationUrl = void 0;
var _i18n = require("@kbn/i18n");
var _use_kibana_version = require("./use_kibana_version");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateCloudFormationUrl = ({
  enrollmentAPIKey,
  cloudFormationTemplateUrl
}) => {
  var _data$item$fleet_serv;
  const {
    data,
    isLoading
  } = (0, _use_request.useGetSettings)();
  const kibanaVersion = (0, _use_kibana_version.useKibanaVersion)();
  let isError = false;
  let error;

  // Default fleet server host
  const fleetServerHost = data === null || data === void 0 ? void 0 : (_data$item$fleet_serv = data.item.fleet_server_hosts) === null || _data$item$fleet_serv === void 0 ? void 0 : _data$item$fleet_serv[0];
  if (!fleetServerHost && !isLoading) {
    isError = true;
    error = _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.noFleetServerHost', {
      defaultMessage: 'No Fleet Server host found'
    });
  }
  if (!enrollmentAPIKey && !isLoading) {
    isError = true;
    error = _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.noApiKey', {
      defaultMessage: 'No enrollment token found'
    });
  }
  const cloudFormationUrl = enrollmentAPIKey && fleetServerHost && cloudFormationTemplateUrl ? createCloudFormationUrl(cloudFormationTemplateUrl, enrollmentAPIKey, fleetServerHost, kibanaVersion) : undefined;
  return {
    isLoading,
    cloudFormationUrl,
    isError,
    error
  };
};
exports.useCreateCloudFormationUrl = useCreateCloudFormationUrl;
const createCloudFormationUrl = (templateURL, enrollmentToken, fleetUrl, kibanaVersion) => {
  const cloudFormationUrl = templateURL.replace('FLEET_ENROLLMENT_TOKEN', enrollmentToken).replace('FLEET_URL', fleetUrl).replace('KIBANA_VERSION', kibanaVersion);
  return new URL(cloudFormationUrl).toString();
};