"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyDeleteProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../hooks");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PackagePolicyDeleteProvider = ({
  agentPolicy,
  children
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    agents: {
      enabled: isFleetEnabled
    }
  } = (0, _hooks.useConfig)();
  const [packagePolicies, setPackagePolicies] = (0, _react.useState)([]);
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const [isLoadingAgentsCount, setIsLoadingAgentsCount] = (0, _react.useState)(false);
  const [agentsCount, setAgentsCount] = (0, _react.useState)(0);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const fetchAgentsCount = (0, _react.useMemo)(() => async () => {
    if (isLoadingAgentsCount || !isFleetEnabled || !agentPolicy) {
      return;
    }
    setIsLoadingAgentsCount(true);
    const {
      data
    } = await (0, _hooks.sendRequest)({
      path: _constants.AGENT_API_ROUTES.LIST_PATTERN,
      method: 'get',
      query: {
        page: 1,
        perPage: 1,
        kuery: `${_constants.AGENTS_PREFIX}.policy_id : ${agentPolicy.id}`
      }
    });
    setAgentsCount((data === null || data === void 0 ? void 0 : data.total) || 0);
    setIsLoadingAgentsCount(false);
  }, [agentPolicy, isFleetEnabled, isLoadingAgentsCount]);
  const deletePackagePoliciesPrompt = (0, _react.useMemo)(() => (packagePoliciesToDelete, onSuccess = () => undefined) => {
    if (!Array.isArray(packagePoliciesToDelete) || packagePoliciesToDelete.length === 0) {
      throw new Error('No package policies specified for deletion');
    }
    setIsModalOpen(true);
    setPackagePolicies(packagePoliciesToDelete);
    fetchAgentsCount();
    onSuccessCallback.current = onSuccess;
  }, [fetchAgentsCount]);
  const closeModal = (0, _react.useMemo)(() => () => {
    setPackagePolicies([]);
    setIsLoading(false);
    setIsLoadingAgentsCount(false);
    setIsModalOpen(false);
  }, []);
  const deletePackagePolicies = (0, _react.useMemo)(() => async () => {
    setIsLoading(true);
    try {
      const {
        data
      } = await (0, _hooks.sendDeletePackagePolicy)({
        packagePolicyIds: packagePolicies
      });
      const successfulResults = (data === null || data === void 0 ? void 0 : data.filter(result => result.success)) || [];
      const failedResults = (data === null || data === void 0 ? void 0 : data.filter(result => !result.success)) || [];
      if (successfulResults.length) {
        const hasMultipleSuccesses = successfulResults.length > 1;
        const successMessage = hasMultipleSuccesses ? _i18n.i18n.translate('xpack.fleet.deletePackagePolicy.successMultipleNotificationTitle', {
          defaultMessage: 'Deleted {count} integrations',
          values: {
            count: successfulResults.length
          }
        }) : _i18n.i18n.translate('xpack.fleet.deletePackagePolicy.successSingleNotificationTitle', {
          defaultMessage: "Deleted integration '{id}'",
          values: {
            id: successfulResults[0].name || successfulResults[0].id
          }
        });
        notifications.toasts.addSuccess(successMessage);
      }
      if (failedResults.length) {
        const hasMultipleFailures = failedResults.length > 1;
        const failureMessage = hasMultipleFailures ? _i18n.i18n.translate('xpack.fleet.deletePackagePolicy.failureMultipleNotificationTitle', {
          defaultMessage: 'Error deleting {count} integrations',
          values: {
            count: failedResults.length
          }
        }) : _i18n.i18n.translate('xpack.fleet.deletePackagePolicy.failureSingleNotificationTitle', {
          defaultMessage: "Error deleting integration '{id}'",
          values: {
            id: failedResults[0].id
          }
        });
        notifications.toasts.addDanger(failureMessage);
      }
      if (onSuccessCallback.current) {
        onSuccessCallback.current(successfulResults.map(result => result.id));
      }
    } catch (e) {
      notifications.toasts.addDanger(_i18n.i18n.translate('xpack.fleet.deletePackagePolicy.fatalErrorNotificationTitle', {
        defaultMessage: 'Error deleting integration'
      }));
    }
    closeModal();
  }, [closeModal, packagePolicies, notifications.toasts]);
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.deleteMultipleTitle",
        defaultMessage: "Delete {count, plural, one {integration} other {# integrations}}?",
        values: {
          count: packagePolicies.length
        }
      }),
      onCancel: closeModal,
      onConfirm: deletePackagePolicies,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel"
      }),
      confirmButtonText: isLoading || isLoadingAgentsCount ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.loadingButtonLabel",
        defaultMessage: "Loading\u2026"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.confirmButtonLabel",
        defaultMessage: "Delete {agentPoliciesCount, plural, one {integration} other {integrations}}",
        values: {
          agentPoliciesCount: packagePolicies.length
        }
      }),
      buttonColor: "danger",
      confirmButtonDisabled: isLoading || isLoadingAgentsCount
    }, isLoadingAgentsCount ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deletePackagePolicy.confirmModal.loadingAgentsCountMessage",
      defaultMessage: "Checking affected agents\u2026"
    }) : agentsCount ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.affectedAgentsTitle",
        defaultMessage: "This action will affect {agentsCount} {agentsCount, plural, one {agent} other {agents}}.",
        values: {
          agentsCount
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deletePackagePolicy.confirmModal.affectedAgentsMessage",
      defaultMessage: "Fleet has detected that {agentPolicyName} is already in use by some of your agents.",
      values: {
        agentPolicyName: /*#__PURE__*/_react.default.createElement("strong", null, agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.name)
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    })) : null, !isLoadingAgentsCount && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deletePackagePolicy.confirmModal.generalMessage",
      defaultMessage: "This action can not be undone. Are you sure you wish to continue?"
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, children(deletePackagePoliciesPrompt), renderModal());
};
exports.PackagePolicyDeleteProvider = PackagePolicyDeleteProvider;