"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _installation_message = require("../agent_enrollment_flyout/installation_message");
var _platform_selector = require("../platform_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InstallSection = ({
  installCommand,
  isK8s,
  cloudSecurityIntegration,
  enrollToken,
  fullCopyButton = false,
  isManaged = true,
  onCopy
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_installation_message.InstallationMessage, {
    isK8s: isK8s,
    isManaged: isManaged
  }), /*#__PURE__*/_react.default.createElement(_platform_selector.PlatformSelector, {
    fullCopyButton: fullCopyButton,
    onCopy: onCopy,
    linuxCommand: installCommand.linux,
    macCommand: installCommand.mac,
    windowsCommand: installCommand.windows,
    linuxDebCommand: installCommand.deb,
    linuxRpmCommand: installCommand.rpm,
    k8sCommand: installCommand.kubernetes,
    hasK8sIntegration: isK8s === 'IS_KUBERNETES' || isK8s === 'IS_KUBERNETES_MULTIPAGE',
    cloudSecurityIntegration: cloudSecurityIntegration,
    hasK8sIntegrationMultiPage: isK8s === 'IS_KUBERNETES_MULTIPAGE',
    isManaged: isManaged,
    enrollToken: enrollToken
  }));
};
exports.InstallSection = InstallSection;