"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetsAccordion = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../constants");
var _hooks = require("../../../../../hooks");
var _types = require("../../../../../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssetsAccordion = ({
  savedObjects,
  type
}) => {
  const {
    http
  } = (0, _hooks.useStartServices)();
  const isDashboard = type === _types.KibanaAssetType.dashboard;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: isDashboard,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _constants.AssetTitleMap[type]))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "subdued",
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h3", null, savedObjects.length)))),
    id: type
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    hasShadow: false
  }, savedObjects.map(({
    id,
    attributes: {
      title: soTitle,
      description
    }
  }, idx) => {
    // Ignore custom asset views or if not a Kibana asset
    if (type === 'view') {
      return;
    }
    const pathToObjectInApp = (0, _hooks.getHrefToObjectInKibanaApp)({
      http,
      id,
      type: type === _types.ElasticsearchAssetType.transform ? undefined : type
    });
    const title = soTitle !== null && soTitle !== void 0 ? soTitle : id;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      grow: false,
      key: idx
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("p", null, pathToObjectInApp ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: pathToObjectInApp
    }, title) : title)), description && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, description)))), idx + 1 < savedObjects.length && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    }));
  }))));
};
exports.AssetsAccordion = AssetsAccordion;