"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceTitleMap = exports.ServiceIcons = exports.DisplayedAssets = exports.AssetTitleMap = exports.AssetIcons = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DisplayedAssets = {
  kibana: Object.values(_types.KibanaAssetType),
  elasticsearch: Object.values(_types.ElasticsearchAssetType)
};
exports.DisplayedAssets = DisplayedAssets;
const AssetTitleMap = {
  dashboard: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.dashboards', {
    defaultMessage: 'Dashboards'
  }),
  ilm_policy: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.ilmPolicies', {
    defaultMessage: 'ILM policies'
  }),
  ingest_pipeline: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.ingestPipelines', {
    defaultMessage: 'Ingest pipelines'
  }),
  transform: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.transforms', {
    defaultMessage: 'Transforms'
  }),
  index: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.indices', {
    defaultMessage: 'Indices'
  }),
  index_pattern: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.indexPatterns', {
    defaultMessage: 'Index patterns'
  }),
  index_template: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.indexTemplates', {
    defaultMessage: 'Index templates'
  }),
  component_template: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.componentTemplates', {
    defaultMessage: 'Component templates'
  }),
  search: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.savedSearches', {
    defaultMessage: 'Saved searches'
  }),
  visualization: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.visualizations', {
    defaultMessage: 'Visualizations'
  }),
  map: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.maps', {
    defaultMessage: 'Maps'
  }),
  data_stream_ilm_policy: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.dataStreamILM', {
    defaultMessage: 'Data stream ILM policies'
  }),
  lens: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.lens', {
    defaultMessage: 'Lens'
  }),
  security_rule: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.securityRules', {
    defaultMessage: 'Security rules'
  }),
  osquery_pack_asset: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.osqueryPackAssets', {
    defaultMessage: 'Osquery packs'
  }),
  osquery_saved_query: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.osquerySavedQuery', {
    defaultMessage: 'Osquery saved queries'
  }),
  ml_module: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.mlModules', {
    defaultMessage: 'ML modules'
  }),
  ml_model: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.mlModels', {
    defaultMessage: 'ML models'
  }),
  view: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.views', {
    defaultMessage: 'Views'
  }),
  tag: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.tag', {
    defaultMessage: 'Tag'
  }),
  csp_rule_template: _i18n.i18n.translate('xpack.fleet.epm.assetTitles.cloudSecurityPostureRuleTemplate', {
    defaultMessage: 'Cloud Security Posture rule template'
  })
};
exports.AssetTitleMap = AssetTitleMap;
const ServiceTitleMap = {
  kibana: 'Kibana',
  elasticsearch: 'Elasticsearch'
};
exports.ServiceTitleMap = ServiceTitleMap;
const AssetIcons = {
  dashboard: 'dashboardApp',
  index_pattern: 'indexPatternApp',
  search: 'searchProfilerApp',
  visualization: 'visualizeApp',
  map: 'emsApp',
  lens: 'lensApp',
  security_rule: 'securityApp',
  csp_rule_template: 'securityApp',
  // TODO ICON
  ml_module: 'mlApp',
  tag: 'tagApp',
  osquery_pack_asset: 'osqueryApp',
  osquery_saved_query: 'osqueryApp'
};
exports.AssetIcons = AssetIcons;
const ServiceIcons = {
  elasticsearch: 'logoElasticsearch',
  kibana: 'logoKibana'
};
exports.ServiceIcons = ServiceIcons;