"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerHostsSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _fleet_server_hosts_table = require("../fleet_server_hosts_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FleetServerHostsSection = ({
  fleetServerHosts,
  deleteFleetServerHost
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": "fleetServerHostHeader"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostSectionTitle",
    defaultMessage: "Fleet server hosts"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostSectionSubtitle",
    defaultMessage: "Specify the URLs that your agents will use to connect to a Fleet Server. If multiple URLs exist, Fleet will show the first provided URL for enrollment purposes. For more information, see the {guideLink} .",
    values: {
      guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.guide,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.fleetUserGuideLink",
        defaultMessage: "Fleet and Elastic Agent Guide"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_fleet_server_hosts_table.FleetServerHostsTable, {
    fleetServerHosts: fleetServerHosts,
    deleteFleetServerHost: deleteFleetServerHost
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    href: getHref('settings_create_fleet_server_hosts'),
    "data-test-subj": "settings.fleetServerHosts.addFleetServerHostBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostCreateButtonLabel",
    defaultMessage: "Add Fleet Server"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.FleetServerHostsSection = FleetServerHostsSection;