"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditOutputFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _multi_row_input = require("../multi_row_input");
var _constants = require("../../constants");
var _logstash_instructions = require("../logstash_instructions");
var _hooks = require("../../../../hooks");
var _yaml_code_editor_with_placeholder = require("./yaml_code_editor_with_placeholder");
var _use_output_form = require("./use_output_form");
var _encryption_key_required_callout = require("./encryption_key_required_callout");
var _advanced_options_section = require("./advanced_options_section");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OUTPUT_TYPE_OPTIONS = [{
  value: 'elasticsearch',
  text: 'Elasticsearch'
}, {
  value: 'logstash',
  text: 'Logstash'
}];
const EditOutputFlyout = ({
  onClose,
  output,
  proxies
}) => {
  (0, _hooks.useBreadcrumbs)('settings');
  const form = (0, _use_output_form.useOutputForm)(onClose, output);
  const inputs = form.inputs;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const proxiesOptions = (0, _react.useMemo)(() => proxies.map(proxy => ({
    value: proxy.id,
    label: proxy.name
  })), [proxies]);
  const isLogstashOutput = inputs.typeInput.value === 'logstash';
  const isESOutput = inputs.typeInput.value === 'elasticsearch';
  const showLogstashNeedEncryptedSavedObjectCallout = isLogstashOutput && !form.hasEncryptedSavedObjectConfigured;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    maxWidth: _constants.FLYOUT_MAX_WIDTH,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "FleetEditOutputFlyoutTitle"
  }, !output ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.createTitle",
    defaultMessage: "Add new output"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.editTitle",
    defaultMessage: "Edit output"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, (output === null || output === void 0 ? void 0 : output.is_preconfigured) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "lock",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.preconfiguredOutputCalloutTitle",
      defaultMessage: "This output is managed outside of Fleet"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.preconfiguredOutputCalloutDescription",
    defaultMessage: "Most actions related to this output are unavailable. Refer to your kibana config for more detail."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.nameInputLabel",
      defaultMessage: "Name"
    })
  }, inputs.nameInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "settingsOutputsFlyout.nameInput",
    fullWidth: true
  }, inputs.nameInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.nameInputPlaceholder', {
      defaultMessage: 'Specify name'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.typeInputLabel",
      defaultMessage: "Type"
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.typeInput"
  }, inputs.typeInput.props, {
    options: OUTPUT_TYPE_OPTIONS,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.typeInputPlaceholder', {
      defaultMessage: 'Specify type'
    })
  })), isESOutput && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.esOutputTypeCallout', {
      defaultMessage: 'This output type currently does not support connectivity to a remote Elasticsearch cluster.'
    }),
    iconType: "alert",
    color: "warning",
    size: "s",
    heading: "p"
  })))), showLogstashNeedEncryptedSavedObjectCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_encryption_key_required_callout.EncryptionKeyRequiredCallout, null)), isLogstashOutput && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_logstash_instructions.LogstashInstructions, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), isESOutput && /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    "data-test-subj": "settingsOutputsFlyout.hostUrlInput",
    label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.esHostsInputLabel', {
      defaultMessage: 'Hosts'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.esHostsInputPlaceholder', {
      defaultMessage: 'Specify host URL'
    })
  }, inputs.elasticsearchUrlInput.props, {
    isUrl: true
  })), isLogstashOutput && /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.logstashHostsInputPlaceholder', {
      defaultMessage: 'Specify host'
    }),
    sortable: false,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.logstashHostsInputDescription",
      defaultMessage: "Specify the addresses that your agents will use to connect to Logstash. {guideLink}.",
      values: {
        guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.settings,
          target: "_blank",
          external: true
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.fleetSettingsLink",
          defaultMessage: "Learn more"
        }))
      }
    }),
    label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.logstashHostsInputLabel', {
      defaultMessage: 'Logstash hosts'
    })
  }, inputs.logstashHostsInput.props)), isESOutput && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.caTrustedFingerprintInputLabel",
      defaultMessage: "Elasticsearch CA trusted fingerprint (optional)"
    })
  }, inputs.caTrustedFingerprintInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    fullWidth: true
  }, inputs.caTrustedFingerprintInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.caTrustedFingerprintInputPlaceholder', {
      defaultMessage: 'Specify Elasticsearch CA trusted fingerprint'
    })
  }))), isLogstashOutput && /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputPlaceholder', {
      defaultMessage: 'Specify certificate authority'
    }),
    label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputLabel', {
      defaultMessage: 'Server SSL certificate authorities (optional)'
    }),
    multiline: true,
    sortable: false
  }, inputs.sslCertificateAuthoritiesInput.props)), isLogstashOutput && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.sslCertificateInputLabel",
      defaultMessage: "Client SSL certificate"
    })
  }, inputs.sslCertificateInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslCertificateInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslCertificateInputPlaceholder', {
      defaultMessage: 'Specify ssl certificate'
    })
  }))), isLogstashOutput && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.sslKeyInputLabel",
      defaultMessage: "Client SSL certificate key"
    })
  }, inputs.sslKeyInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslKeyInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder', {
      defaultMessage: 'Specify certificate key'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.proxyIdLabel",
      defaultMessage: "Proxy"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.proxyIdInput"
  }, inputs.proxyIdInput.props, {
    onChange: options => {
      var _options$0$value, _options$;
      return inputs.proxyIdInput.setValue((_options$0$value = options === null || options === void 0 ? void 0 : (_options$ = options[0]) === null || _options$ === void 0 ? void 0 : _options$.value) !== null && _options$0$value !== void 0 ? _options$0$value : '');
    },
    selectedOptions: inputs.proxyIdInput.value !== '' ? proxiesOptions.filter(option => option.value === inputs.proxyIdInput.value) : [],
    options: proxiesOptions,
    singleSelection: {
      asPlainText: true
    },
    isDisabled: inputs.proxyIdInput.props.disabled,
    isClearable: true,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.proxyIdPlaceholder', {
      defaultMessage: 'Select proxy'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.yamlConfigInputLabel', {
      defaultMessage: 'Advanced YAML configuration'
    })
  }, inputs.additionalYamlConfigInput.formRowProps, {
    fullWidth: true
  }), /*#__PURE__*/_react.default.createElement(_yaml_code_editor_with_placeholder.YamlCodeEditorWithPlaceholder, {
    value: inputs.additionalYamlConfigInput.value,
    onChange: inputs.additionalYamlConfigInput.setValue,
    disabled: inputs.additionalYamlConfigInput.props.disabled,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.yamlConfigInputPlaceholder', {
      defaultMessage: '# YAML settings here will be added to the output section of each agent policy.'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, inputs.defaultOutputInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({}, inputs.defaultOutputInput.props, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.defaultOutputSwitchLabel",
      defaultMessage: "Make this output the default for {boldAgentIntegrations}.",
      values: {
        boldAgentIntegrations: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.editOutputFlyout.agentIntegrationsBold",
          defaultMessage: "agent integrations"
        }))
      }
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, inputs.defaultMonitoringOutputInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({}, inputs.defaultMonitoringOutputInput.props, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.defaultMontoringOutputSwitchLabel",
      defaultMessage: "Make this output the default for {boldAgentMonitoring}.",
      values: {
        boldAgentMonitoring: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.editOutputFlyout.agentMonitoringBold",
          defaultMessage: "agent monitoring"
        }))
      }
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_advanced_options_section.AdvancedOptionsSection, {
    enabled: form.isShipperEnabled,
    inputs: inputs
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: form.isLoading,
    isDisabled: form.isDisabled,
    onClick: form.submit,
    "data-test-subj": "saveApplySettingsBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.saveButton",
    defaultMessage: "Save and apply settings"
  }))))));
};
exports.EditOutputFlyout = EditOutputFlyout;