"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentStatusRefreshContext = void 0;
exports.useAgentStatusRefresh = useAgentStatusRefresh;
exports.useGetAgentStatus = useGetAgentStatus;
var _react = _interopRequireDefault(require("react"));
var _hooks = require("../../../../hooks");
var _services = require("../../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetAgentStatus(policyId, options) {
  const agentStatusRequest = (0, _hooks.useRequest)({
    path: _services.agentRouteService.getStatusPath(),
    query: {
      policyId
    },
    method: 'get',
    ...options
  });
  return {
    isLoading: agentStatusRequest.isLoading,
    data: agentStatusRequest.data,
    error: agentStatusRequest.error,
    refreshAgentStatus: () => agentStatusRequest.resendRequest
  };
}
const AgentStatusRefreshContext = /*#__PURE__*/_react.default.createContext({
  refresh: () => {}
});
exports.AgentStatusRefreshContext = AgentStatusRefreshContext;
function useAgentStatusRefresh() {
  return _react.default.useContext(AgentStatusRefreshContext).refresh;
}