"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreatePackagePolicySinglePage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _transform_install_as_current_user_callout = require("../../../../../../components/transform_install_as_current_user_callout");
var _hooks = require("../hooks");
var _services = require("../../../../../../../common/services");
var _services2 = require("../../../../services");
var _hooks2 = require("../../../../hooks");
var _components = require("../../../../components");
var _components2 = require("../../components");
var _components3 = require("../components");
var _components4 = require("./components");
var _hooks3 = require("./hooks");
var _post_install_cloud_formation_modal = require("./components/post_install_cloud_formation_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepsWithLessPadding = (0, _styledComponents.default)(_eui.EuiSteps)`
  .euiStep__content {
    padding-bottom: ${props => props.theme.eui.euiSizeM};
  }

  // compensating for EuiBottomBar hiding the content
  @media (max-width: ${props => props.theme.eui.euiBreakpoints.m}) {
    margin-bottom: 100px;
  }
`;
const CustomEuiBottomBar = (0, _styledComponents.default)(_eui.EuiBottomBar)`
  /* A relatively _low_ z-index value here to account for EuiComboBox popover that might appear under the bottom bar */
  z-index: 50;
`;
const CreatePackagePolicySinglePage = ({
  from,
  queryParamsPolicyId,
  prerelease
}) => {
  var _packagePolicy$packag, _packagePolicy$packag2, _packagePolicy$packag3, _packagePolicy$packag4;
  const {
    agents: {
      enabled: isFleetEnabled
    }
  } = (0, _hooks2.useConfig)();
  const {
    params
  } = (0, _reactRouterDom.useRouteMatch)();
  const [newAgentPolicy, setNewAgentPolicy] = (0, _react.useState)((0, _services2.generateNewAgentPolicyWithDefaults)({
    name: 'Agent policy 1'
  }));
  const [withSysMonitoring, setWithSysMonitoring] = (0, _react.useState)(true);
  const validation = (0, _components2.agentPolicyFormValidation)(newAgentPolicy);
  const [selectedPolicyTab, setSelectedPolicyTab] = (0, _react.useState)(queryParamsPolicyId ? _components3.SelectedPolicyTab.EXISTING : _components3.SelectedPolicyTab.NEW);
  const {
    pkgName,
    pkgVersion
  } = (0, _services.splitPkgKey)(params.pkgkey);
  // Fetch package info
  const {
    data: packageInfoData,
    error: packageInfoError,
    isLoading: isPackageInfoLoading
  } = (0, _hooks2.useGetPackageInfoByKeyQuery)(pkgName, pkgVersion, {
    full: true,
    prerelease
  });
  const packageInfo = (0, _react.useMemo)(() => {
    if (packageInfoData && packageInfoData.item) {
      return packageInfoData.item;
    }
  }, [packageInfoData]);
  const [agentCount, setAgentCount] = (0, _react.useState)(0);
  const integrationInfo = (0, _react.useMemo)(() => {
    var _packageInfo$policy_t;
    return params.integration ? packageInfo === null || packageInfo === void 0 ? void 0 : (_packageInfo$policy_t = packageInfo.policy_templates) === null || _packageInfo$policy_t === void 0 ? void 0 : _packageInfo$policy_t.find(policyTemplate => policyTemplate.name === params.integration) : undefined;
  }, [packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.policy_templates, params]);

  // Save package policy
  const {
    onSubmit,
    updatePackagePolicy,
    packagePolicy,
    agentPolicy,
    updateAgentPolicy,
    savedPackagePolicy,
    formState,
    setFormState,
    navigateAddAgent,
    navigateAddAgentHelp,
    setHasAgentPolicyError,
    validationResults,
    hasAgentPolicyError,
    isInitialized
  } = (0, _hooks3.useOnSubmit)({
    agentCount,
    packageInfo,
    newAgentPolicy,
    selectedPolicyTab,
    withSysMonitoring,
    queryParamsPolicyId,
    integrationToEnable: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name
  });
  const setPolicyValidation = (0, _react.useCallback)((selectedTab, updatedAgentPolicy) => {
    if (selectedTab === _components3.SelectedPolicyTab.NEW) {
      if (!updatedAgentPolicy.name || updatedAgentPolicy.name.trim() === '' || !updatedAgentPolicy.namespace || updatedAgentPolicy.namespace.trim() === '') {
        setHasAgentPolicyError(true);
      } else {
        setHasAgentPolicyError(false);
      }
    }
  }, [setHasAgentPolicyError]);
  const updateNewAgentPolicy = (0, _react.useCallback)(updatedFields => {
    const updatedAgentPolicy = {
      ...newAgentPolicy,
      ...updatedFields
    };
    setNewAgentPolicy(updatedAgentPolicy);
    setPolicyValidation(selectedPolicyTab, updatedAgentPolicy);
  }, [setNewAgentPolicy, setPolicyValidation, newAgentPolicy, selectedPolicyTab]);
  const updateSelectedPolicyTab = (0, _react.useCallback)(selectedTab => {
    setSelectedPolicyTab(selectedTab);
    setPolicyValidation(selectedTab, newAgentPolicy);
  }, [setSelectedPolicyTab, setPolicyValidation, newAgentPolicy]);

  // Retrieve agent count
  const agentPolicyId = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id;
  const {
    cancelClickHandler,
    cancelUrl
  } = (0, _hooks.useCancelAddPackagePolicy)({
    from,
    pkgkey: params.pkgkey,
    agentPolicyId
  });
  (0, _react.useEffect)(() => {
    const getAgentCount = async () => {
      const {
        data
      } = await (0, _hooks2.sendGetAgentStatus)({
        policyId: agentPolicyId
      });
      if ((data === null || data === void 0 ? void 0 : data.results.total) !== undefined) {
        setAgentCount(data.results.total);
      }
    };
    if (isFleetEnabled && agentPolicyId) {
      getAgentCount();
    }
  }, [agentPolicyId, isFleetEnabled]);
  const handleExtensionViewOnChange = (0, _react.useCallback)(({
    isValid,
    updatedPolicy
  }) => {
    updatePackagePolicy(updatedPolicy);
    setFormState(prevState => {
      if (prevState === 'VALID' && !isValid) {
        return 'INVALID';
      }
      return prevState;
    });
  }, [updatePackagePolicy, setFormState]);
  const {
    devtoolRequest,
    devtoolRequestDescription,
    showDevtoolsRequest
  } = (0, _hooks3.useDevToolsRequest)({
    newAgentPolicy,
    packagePolicy,
    selectedPolicyTab,
    withSysMonitoring,
    packageInfo
  });
  const layoutProps = (0, _react.useMemo)(() => ({
    from,
    cancelUrl,
    onCancel: cancelClickHandler,
    agentPolicy,
    packageInfo,
    integrationInfo
  }), [agentPolicy, cancelClickHandler, cancelUrl, from, integrationInfo, packageInfo]);
  const stepSelectAgentPolicy = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_components3.StepSelectHosts, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    newAgentPolicy: newAgentPolicy,
    updateNewAgentPolicy: updateNewAgentPolicy,
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: newValue => setWithSysMonitoring(newValue),
    validation: validation,
    packageInfo: packageInfo,
    setHasAgentPolicyError: setHasAgentPolicyError,
    updateSelectedTab: updateSelectedPolicyTab,
    selectedAgentPolicyId: queryParamsPolicyId
  }), [packageInfo, agentPolicy, updateAgentPolicy, newAgentPolicy, updateNewAgentPolicy, validation, withSysMonitoring, updateSelectedPolicyTab, queryParamsPolicyId, setHasAgentPolicyError]);
  const numTransformAssets = (0, _react.useMemo)(() => (0, _transform_install_as_current_user_callout.getNumTransformAssets)(packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.assets), [packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.assets]);
  const extensionView = (0, _hooks2.useUIExtension)((_packagePolicy$packag = (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.name) !== null && _packagePolicy$packag !== void 0 ? _packagePolicy$packag : '', 'package-policy-create');
  const replaceDefineStepView = (0, _hooks2.useUIExtension)((_packagePolicy$packag3 = (_packagePolicy$packag4 = packagePolicy.package) === null || _packagePolicy$packag4 === void 0 ? void 0 : _packagePolicy$packag4.name) !== null && _packagePolicy$packag3 !== void 0 ? _packagePolicy$packag3 : '', 'package-policy-replace-define-step');
  if (replaceDefineStepView && extensionView) {
    throw new Error("'package-policy-create' and 'package-policy-replace-define-step' cannot both be registered as UI extensions");
  }
  const replaceStepConfigurePackagePolicy = replaceDefineStepView && packageInfo !== null && packageInfo !== void 0 && packageInfo.name ? !isInitialized ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, null, /*#__PURE__*/_react.default.createElement(replaceDefineStepView.Component, {
    agentPolicy: agentPolicy,
    packageInfo: packageInfo,
    newPolicy: packagePolicy,
    onChange: handleExtensionViewOnChange,
    validationResults: validationResults,
    isEditPage: false
  })) : undefined;
  const stepConfigurePackagePolicy = (0, _react.useMemo)(() => {
    var _packagePolicy$packag5;
    return isPackageInfoLoading || !isInitialized ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : packageInfo ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components3.StepDefinePackagePolicy, {
      agentPolicy: agentPolicy,
      packageInfo: packageInfo,
      packagePolicy: packagePolicy,
      updatePackagePolicy: updatePackagePolicy,
      validationResults: validationResults,
      submitAttempted: formState === 'INVALID'
    }), !extensionView && /*#__PURE__*/_react.default.createElement(_components3.StepConfigurePackagePolicy, {
      packageInfo: packageInfo,
      showOnlyIntegration: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name,
      packagePolicy: packagePolicy,
      updatePackagePolicy: updatePackagePolicy,
      validationResults: validationResults,
      submitAttempted: formState === 'INVALID'
    }), extensionView && ((_packagePolicy$packag5 = packagePolicy.package) === null || _packagePolicy$packag5 === void 0 ? void 0 : _packagePolicy$packag5.name) && /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, null, /*#__PURE__*/_react.default.createElement(extensionView.Component, {
      newPolicy: packagePolicy,
      onChange: handleExtensionViewOnChange
    }))) : /*#__PURE__*/_react.default.createElement("div", null);
  }, [isInitialized, isPackageInfoLoading, agentPolicy, packageInfo, packagePolicy, updatePackagePolicy, validationResults, formState, integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name, extensionView, handleExtensionViewOnChange]);
  const steps = [{
    title: _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepConfigurePackagePolicyTitle', {
      defaultMessage: 'Configure integration'
    }),
    'data-test-subj': 'dataCollectionSetupStep',
    children: replaceStepConfigurePackagePolicy || stepConfigurePackagePolicy
  }, {
    title: _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepSelectAgentPolicyTitle', {
      defaultMessage: 'Where to add this integration?'
    }),
    children: stepSelectAgentPolicy
  }];

  // Display package error if there is one
  if (packageInfoError) {
    return /*#__PURE__*/_react.default.createElement(_components.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.StepSelectPolicy.errorLoadingPackageTitle",
        defaultMessage: "Error loading package information"
      }),
      error: packageInfoError
    });
  }
  return /*#__PURE__*/_react.default.createElement(_components4.CreatePackagePolicySinglePageLayout, (0, _extends2.default)({}, layoutProps, {
    "data-test-subj": "createPackagePolicy"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, formState === 'CONFIRM' && agentPolicy && /*#__PURE__*/_react.default.createElement(_components2.ConfirmDeployAgentPolicyModal, {
    agentCount: agentCount,
    agentPolicy: agentPolicy,
    onConfirm: onSubmit,
    onCancel: () => setFormState('VALID')
  }), formState === 'SUBMITTED_NO_AGENTS' && agentPolicy && packageInfo && savedPackagePolicy && /*#__PURE__*/_react.default.createElement(_components4.PostInstallAddAgentModal, {
    packageInfo: packageInfo,
    onConfirm: () => navigateAddAgent(savedPackagePolicy),
    onCancel: () => navigateAddAgentHelp(savedPackagePolicy)
  }), formState === 'SUBMITTED_CLOUD_FORMATION' && agentPolicy && savedPackagePolicy && /*#__PURE__*/_react.default.createElement(_post_install_cloud_formation_modal.PostInstallCloudFormationModal, {
    agentPolicy: agentPolicy,
    packagePolicy: savedPackagePolicy,
    onConfirm: () => navigateAddAgent(savedPackagePolicy),
    onCancel: () => navigateAddAgentHelp(savedPackagePolicy)
  }), packageInfo && /*#__PURE__*/_react.default.createElement(_components3.IntegrationBreadcrumb, {
    pkgTitle: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || packageInfo.title,
    pkgkey: (0, _services2.pkgKeyFromPackageInfo)(packageInfo),
    integration: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name
  }), numTransformAssets > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_transform_install_as_current_user_callout.TransformInstallWithCurrentUserPermissionCallout, {
    count: numTransformAssets
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })) : null, /*#__PURE__*/_react.default.createElement(StepsWithLessPadding, {
    steps: steps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(CustomEuiBottomBar, {
    "data-test-subj": "integrationsBottomBar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, packageInfo && (formState === 'INVALID' || hasAgentPolicyError) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.errorOnSaveText",
    defaultMessage: "Your integration policy has errors. Please fix them before saving."
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "ghost",
    href: cancelUrl,
    onClick: cancelClickHandler,
    "data-test-subj": "createPackagePolicyCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.cancelButton",
    defaultMessage: "Cancel"
  }))), showDevtoolsRequest ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.DevtoolsRequestFlyoutButton, {
    request: devtoolRequest,
    description: devtoolRequestDescription,
    btnProps: {
      color: 'ghost'
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => onSubmit(),
    isLoading: formState === 'LOADING',
    disabled: formState !== 'VALID' || hasAgentPolicyError || !validationResults,
    iconType: "save",
    color: "primary",
    fill: true,
    "data-test-subj": "createPackagePolicySaveButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.saveButton",
    defaultMessage: "Save and continue"
  })))))))));
};
exports.CreatePackagePolicySinglePage = CreatePackagePolicySinglePage;