"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmIncomingDataTimeout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../hooks");
var _bottom_bar = require("./bottom_bar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmIncomingDataTimeout = ({
  agentIds,
  troubleshootLink,
  packageInfo
}) => {
  var _packageInfo$title;
  const discoverLogsLink = (0, _hooks.useGetDiscoverLogsLinkForAgents)(agentIds);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.confirmIncomingData.timeout.title",
    defaultMessage: "Confirming data is taking longer than expected"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.confirmIncomingData.timeout.body",
    defaultMessage: "If the system is not generating data, it may help to generate some to ensure data is being collected correctly. If you're having trouble, see our {troubleshootLink}, or you may check later by viewing {discoverLink}.",
    values: {
      troubleshootLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: troubleshootLink,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.confirmIncomingData.timeout.troubleshootLink",
        defaultMessage: "troubleshooting guide"
      })),
      discoverLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: discoverLogsLink !== null && discoverLogsLink !== void 0 ? discoverLogsLink : '',
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.confirmIncomingData.timeout.discoverLink",
        defaultMessage: "{integration} logs in Discover",
        values: {
          integration: (_packageInfo$title = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.title) !== null && _packageInfo$title !== void 0 ? _packageInfo$title : ''
        }
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_bottom_bar.NotObscuredByBottomBar, null), /*#__PURE__*/_react.default.createElement(_bottom_bar.AgentDataTimedOutBottomBar, {
    agentIds: agentIds,
    troubleshootLink: troubleshootLink,
    integration: packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.title
  }));
};
exports.ConfirmIncomingDataTimeout = ConfirmIncomingDataTimeout;