"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndexTemplateExists = useIndexTemplateExists;
exports.usePackagePolicyEditorPageUrl = usePackagePolicyEditorPageUrl;
var _reactRouterDom = require("react-router-dom");
var _reactQuery = require("@tanstack/react-query");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function usePackagePolicyEditorPageUrl(dataStreamId) {
  const {
    params: {
      packagePolicyId,
      policyId
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const baseUrl = packagePolicyId && policyId ? getHref('edit_integration', {
    policyId,
    packagePolicyId
  }) : getHref('integration_policy_edit', {
    packagePolicyId
  });
  return `${baseUrl}${dataStreamId ? `?datastreamId=${encodeURIComponent(dataStreamId)}` : ''}`;
}
function useIndexTemplateExists(templateName, enabled = true) {
  const {
    data,
    isLoading
  } = (0, _reactQuery.useQuery)(['indexTemplateExists', templateName], () => (0, _hooks.sendRequestForRq)({
    path: `/api/index_management/index_templates/${templateName}`,
    method: 'get'
  }), {
    enabled
  });
  if (isLoading) {
    return {
      isLoading: true
    };
  }
  return {
    exists: !!data,
    isLoading: false
  };
}