"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSelectAgentPolicyStep = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _ = require("../..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSelectAgentPolicyStep = ({
  policyId,
  setPolicyId,
  eligibleFleetServerPolicies,
  refreshEligibleFleetServerPolicies
}) => {
  return {
    title: eligibleFleetServerPolicies.length === 0 && !policyId ? _i18n.i18n.translate('xpack.fleet.fleetServerSetup.stepCreateAgentPolicyTitle', {
      defaultMessage: 'Create a policy for Fleet Server'
    }) : _i18n.i18n.translate('xpack.fleet.fleetServerSetup.stepSelectAgentPolicyTitle', {
      defaultMessage: 'Select a policy for Fleet Server'
    }),
    status: policyId ? 'complete' : undefined,
    children: /*#__PURE__*/_react.default.createElement(SelectAgentPolicyStepContent, {
      policyId: policyId,
      setPolicyId: setPolicyId,
      eligibleFleetServerPolicies: eligibleFleetServerPolicies,
      refreshEligibleFleetServerPolicies: refreshEligibleFleetServerPolicies
    })
  };
};
exports.getSelectAgentPolicyStep = getSelectAgentPolicyStep;
const SelectAgentPolicyStepContent = ({
  policyId,
  setPolicyId,
  eligibleFleetServerPolicies,
  refreshEligibleFleetServerPolicies
}) => {
  (0, _react.useEffect)(() => {
    // Select default value
    if (eligibleFleetServerPolicies.length === 1 && !policyId) {
      setPolicyId(eligibleFleetServerPolicies[0].id);
    }
  }, [eligibleFleetServerPolicies, policyId, setPolicyId]);
  const setSelectedPolicyId = agentPolicyId => {
    setPolicyId(agentPolicyId);
  };
  return /*#__PURE__*/_react.default.createElement(_.SelectCreateAgentPolicy, {
    agentPolicies: eligibleFleetServerPolicies,
    withKeySelection: false,
    selectedPolicyId: policyId,
    setSelectedPolicyId: setSelectedPolicyId,
    refreshAgentPolicies: refreshEligibleFleetServerPolicies,
    excludeFleetServer: false,
    isFleetServerPolicy: true
  });
};