"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAddFleetServerHostStep = exports.AddFleetServerHostStepContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _multi_row_input = require("../../../sections/settings/components/multi_row_input");
var _components = require("../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAddFleetServerHostStep = ({
  fleetServerHostForm,
  disabled,
  onClose
}) => {
  return {
    title: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.addFleetServerHostStepTitle', {
      defaultMessage: 'Add your Fleet Server host'
    }),
    status: disabled ? 'disabled' : undefined,
    children: disabled ? null : /*#__PURE__*/_react.default.createElement(AddFleetServerHostStepContent, {
      fleetServerHostForm: fleetServerHostForm,
      onClose: onClose
    })
  };
};
exports.getAddFleetServerHostStep = getAddFleetServerHostStep;
const AddFleetServerHostStepContent = ({
  fleetServerHostForm,
  onClose
}) => {
  const {
    setFleetServerHost,
    fleetServerHost: selectedFleetServerHost,
    saveFleetServerHost,
    fleetServerHosts,
    error,
    validate,
    inputs
  } = fleetServerHostForm;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [submittedFleetServerHost, setSubmittedFleetServerHost] = (0, _react.useState)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const onSubmit = (0, _react.useCallback)(async () => {
    try {
      setSubmittedFleetServerHost(undefined);
      setIsLoading(true);
      const newFleetServerHost = {
        name: inputs.nameInput.value,
        host_urls: inputs.hostUrlsInput.value,
        is_default: true,
        id: 'fleet-server-host',
        is_preconfigured: false
      };
      if (validate()) {
        setFleetServerHost(await saveFleetServerHost(newFleetServerHost));
        setSubmittedFleetServerHost(newFleetServerHost);
      }
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.errorAddingFleetServerHostTitle', {
          defaultMessage: 'Error adding Fleet Server host'
        })
      });
    } finally {
      setIsLoading(false);
    }
  }, [inputs.nameInput.value, inputs.hostUrlsInput.value, setFleetServerHost, validate, saveFleetServerHost, notifications.toasts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: onSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.addFleetServerHostStepDescription",
    defaultMessage: "First, set the public IP or host name and port that agents will use to reach Fleet Server. It uses port {port} by default {toolTip}. We'll then generate a policy for you automatically. ",
    values: {
      port: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "8220"),
      toolTip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        iconProps: {
          className: 'eui-alignTop'
        },
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.fleetServerSetup.getStartedInstructionsPortTooltips",
          defaultMessage: "This can only be set during Fleet Server installation."
        }),
        position: "right"
      })
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), selectedFleetServerHost ? /*#__PURE__*/_react.default.createElement(_components.FleetServerHostSelect, {
    setFleetServerHost: setFleetServerHost,
    selectedFleetServerHost: selectedFleetServerHost,
    fleetServerHosts: fleetServerHosts
  }) : null, !selectedFleetServerHost ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.nameInputLabel",
      defaultMessage: "Name"
    })
  }, inputs.nameInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "fleetServerSetup.nameInput",
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.nameInputPlaceholder', {
      defaultMessage: 'Specify name'
    })
  }, inputs.nameInput.props))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.hostUrlLabel",
      defaultMessage: "URL"
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    "data-test-subj": "fleetServerSetup.multiRowInput"
  }, inputs.hostUrlsInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.fleetServerHostsInputPlaceholder', {
      defaultMessage: 'Specify host URL'
    }),
    isUrl: true
  })), error && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, null, error))), fleetServerHosts.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, inputs.isDefaultInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": "fleetServerHostsFlyout.isDefaultSwitch"
  }, inputs.isDefaultInput.props, {
    disabled: false,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.defaultOutputSwitchLabel",
      defaultMessage: "Make this Fleet server the default one."
    })
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    onClick: onSubmit,
    "data-test-subj": "fleetServerAddHostBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.addFleetServerHostButton",
    defaultMessage: "Add host"
  }))) : null, submittedFleetServerHost && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "check",
    size: "s",
    color: "success",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.addFleetServerHostSuccessTitle",
      defaultMessage: "Added Fleet Server host"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.addFleetServerHostSuccessText",
    defaultMessage: "Added {host}. You can edit your Fleet Server hosts in {fleetSettingsLink}.",
    values: {
      host: submittedFleetServerHost.host_urls[0],
      fleetSettingsLink:
      /*#__PURE__*/
      // eslint-disable-next-line @elastic/eui/href-or-on-click
      _react.default.createElement(_eui.EuiButtonEmpty, {
        href: getHref('settings'),
        onClick: onClose,
        flush: "left"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleetServerSetup.fleetSettingsLink",
        defaultMessage: "Fleet Settings"
      }))
    }
  }))));
};
exports.AddFleetServerHostStepContent = AddFleetServerHostStepContent;