"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdvancedForm = void 0;
var _react = require("react");
var _use_fleet_server_host = require("./use_fleet_server_host");
var _use_select_fleet_server_policy = require("./use_select_fleet_server_policy");
var _use_service_token = require("./use_service_token");
var _use_wait_for_fleet_server = require("./use_wait_for_fleet_server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides all data/state required for the "advanced" tab in the Fleet Server instructions/flyout
 */
const useAdvancedForm = defaultAgentPolicyId => {
  const {
    isSelectFleetServerPolicyLoading,
    eligibleFleetServerPolicies,
    refreshEligibleFleetServerPolicies,
    fleetServerPolicyId,
    setFleetServerPolicyId
  } = (0, _use_select_fleet_server_policy.useSelectFleetServerPolicy)(defaultAgentPolicyId);
  const {
    isFleetServerReady
  } = (0, _use_wait_for_fleet_server.useWaitForFleetServer)();
  const {
    serviceToken,
    isLoadingServiceToken,
    generateServiceToken
  } = (0, _use_service_token.useServiceToken)();
  const fleetServerHostForm = (0, _use_fleet_server_host.useFleetServerHost)();
  const [deploymentMode, setDeploymentMode] = (0, _react.useState)('quickstart');
  return {
    isSelectFleetServerPolicyLoading,
    eligibleFleetServerPolicies,
    refreshEligibleFleetServerPolicies,
    fleetServerPolicyId,
    setFleetServerPolicyId,
    isFleetServerReady,
    serviceToken,
    isLoadingServiceToken,
    generateServiceToken,
    fleetServerHostForm,
    deploymentMode,
    setDeploymentMode
  };
};
exports.useAdvancedForm = useAdvancedForm;