"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoUploadWizard = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _kibana_services = require("../kibana_services");
var _geo_upload_form = require("./geo_upload_form");
var _import_complete_view = require("./import_complete_view");
var _api = require("../api");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var PHASE;
(function (PHASE) {
  PHASE["CONFIGURE"] = "CONFIGURE";
  PHASE["IMPORT"] = "IMPORT";
  PHASE["COMPLETE"] = "COMPLETE";
})(PHASE || (PHASE = {}));
function getWritingToIndexMsg(progress) {
  return _i18n.i18n.translate('xpack.fileUpload.geoUploadWizard.writingToIndex', {
    defaultMessage: 'Writing to index: {progress}% complete',
    values: {
      progress
    }
  });
}
class GeoUploadWizard extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_geoFileImporter", void 0);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      failedPermissionCheck: false,
      geoFieldType: _public.ES_FIELD_TYPES.GEO_SHAPE,
      importStatus: '',
      indexName: '',
      phase: PHASE.CONFIGURE,
      smallChunks: false
    });
    (0, _defineProperty2.default)(this, "_import", async () => {
      var _importResults$failur;
      if (!this._geoFileImporter) {
        return;
      }

      //
      // check permissions
      //
      const canImport = await (0, _api.hasImportPermission)({
        checkCreateDataView: true,
        checkHasManagePipeline: false,
        indexName: this.state.indexName
      });
      if (!this._isMounted) {
        return;
      }
      if (!canImport) {
        this.setState({
          phase: PHASE.COMPLETE,
          failedPermissionCheck: true
        });
        this.props.onUploadError();
        return;
      }

      //
      // create index
      //
      const settings = {
        number_of_shards: 1
      };
      const mappings = {
        properties: {
          geometry: {
            type: this.state.geoFieldType
          }
        }
      };
      const ingestPipeline = {
        description: '',
        processors: []
      };
      this.setState({
        importStatus: _i18n.i18n.translate('xpack.fileUpload.geoUploadWizard.dataIndexingStarted', {
          defaultMessage: 'Creating index: {indexName}',
          values: {
            indexName: this.state.indexName
          }
        }),
        phase: PHASE.IMPORT
      });
      this._geoFileImporter.setGeoFieldType(this.state.geoFieldType);
      const initializeImportResp = await this._geoFileImporter.initializeImport(this.state.indexName, settings, mappings, ingestPipeline);
      if (!this._isMounted) {
        return;
      }
      if (initializeImportResp.index === undefined || initializeImportResp.id === undefined) {
        this.setState({
          phase: PHASE.COMPLETE,
          importResults: initializeImportResp
        });
        this.props.onUploadError();
        return;
      }

      //
      // import file
      //
      this.setState({
        importStatus: getWritingToIndexMsg(0)
      });
      this._geoFileImporter.setSmallChunks(this.state.smallChunks);
      const importResults = await this._geoFileImporter.import(initializeImportResp.id, this.state.indexName, initializeImportResp.pipelineId, progress => {
        if (this._isMounted) {
          this.setState({
            importStatus: getWritingToIndexMsg(progress)
          });
        }
      });
      if (!this._isMounted) {
        return;
      }
      if (!importResults.success) {
        this.setState({
          importResults,
          importStatus: _i18n.i18n.translate('xpack.fileUpload.geoUploadWizard.dataIndexingError', {
            defaultMessage: 'Data indexing error'
          }),
          phase: PHASE.COMPLETE
        });
        this.props.onUploadError();
        return;
      } else if (importResults.docCount === ((_importResults$failur = importResults.failures) === null || _importResults$failur === void 0 ? void 0 : _importResults$failur.length)) {
        this.setState({
          // Force importResults into failure shape when no features are indexed
          importResults: {
            ...importResults,
            success: false,
            error: {
              error: {
                reason: (0, _utils.getPartialImportMessage)(importResults.failures.length, importResults.docCount)
              }
            }
          },
          phase: PHASE.COMPLETE
        });
        this.props.onUploadError();
        return;
      }

      //
      // create index pattern
      //
      this.setState({
        importResults,
        importStatus: _i18n.i18n.translate('xpack.fileUpload.geoUploadWizard.creatingDataView', {
          defaultMessage: 'Creating data view: {indexName}',
          values: {
            indexName: this.state.indexName
          }
        })
      });
      let dataView;
      let results;
      try {
        dataView = await (0, _kibana_services.getDataViewsService)().createAndSave({
          title: this.state.indexName
        }, true);
        if (!dataView.id) {
          throw new Error('id not provided');
        }
        const geoField = dataView.fields.find(field => [_public.ES_FIELD_TYPES.GEO_POINT, _public.ES_FIELD_TYPES.GEO_SHAPE].includes(field.type));
        if (!geoField) {
          throw new Error('geo field not created');
        }
        results = {
          indexPatternId: dataView.id,
          geoFieldName: geoField.name,
          geoFieldType: geoField.type,
          docCount: importResults.docCount !== undefined ? importResults.docCount : 0
        };
      } catch (error) {
        if (this._isMounted) {
          this.setState({
            importStatus: _i18n.i18n.translate('xpack.fileUpload.geoUploadWizard.dataViewError', {
              defaultMessage: 'Unable to create data view'
            }),
            phase: PHASE.COMPLETE
          });
          this.props.onUploadError();
        }
        return;
      }
      if (!this._isMounted) {
        return;
      }

      //
      // Successful import
      //
      this.setState({
        dataViewResp: {
          success: true,
          id: dataView.id,
          fields: dataView.fields
        },
        phase: PHASE.COMPLETE,
        importStatus: ''
      });
      this.props.onUploadComplete(results);
    });
    (0, _defineProperty2.default)(this, "_onFileSelect", ({
      features,
      importer,
      indexName,
      previewCoverage
    }) => {
      this._geoFileImporter = importer;
      this.props.onFileSelect({
        type: 'FeatureCollection',
        features
      }, indexName, previewCoverage);
    });
    (0, _defineProperty2.default)(this, "_onFileClear", () => {
      if (this._geoFileImporter) {
        this._geoFileImporter.destroy();
        this._geoFileImporter = undefined;
      }
      this.props.onFileClear();
    });
    (0, _defineProperty2.default)(this, "_onGeoFieldTypeSelect", geoFieldType => {
      this.setState({
        geoFieldType
      });
    });
    (0, _defineProperty2.default)(this, "_onIndexNameChange", (name, error) => {
      this.setState({
        indexName: name,
        indexNameError: error
      });
      const isReadyToImport = !!name && error === undefined;
      if (isReadyToImport) {
        this.props.enableImportBtn();
      } else {
        this.props.disableImportBtn();
      }
    });
    (0, _defineProperty2.default)(this, "_onSmallChunksChange", smallChunks => {
      this.setState({
        smallChunks
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
    if (this._geoFileImporter) {
      this._geoFileImporter.destroy();
      this._geoFileImporter = undefined;
    }
  }
  componentDidUpdate() {
    if (this.props.isIndexingTriggered && this.state.phase === PHASE.CONFIGURE) {
      this._import();
    }
  }
  render() {
    if (this.state.phase === PHASE.IMPORT) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
        size: "xs",
        color: "accent",
        position: "absolute"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, this.state.importStatus)));
    }
    if (this.state.phase === PHASE.COMPLETE) {
      return /*#__PURE__*/_react.default.createElement(_import_complete_view.ImportCompleteView, {
        importResults: this.state.importResults,
        dataViewResp: this.state.dataViewResp,
        indexName: this.state.indexName,
        failedPermissionCheck: this.state.failedPermissionCheck
      });
    }
    return /*#__PURE__*/_react.default.createElement(_geo_upload_form.GeoUploadForm, {
      geoFieldType: this.state.geoFieldType,
      indexName: this.state.indexName,
      indexNameError: this.state.indexNameError,
      onFileClear: this._onFileClear,
      onFileSelect: this._onFileSelect,
      smallChunks: this.state.smallChunks,
      onGeoFieldTypeSelect: this._onGeoFieldTypeSelect,
      onIndexNameChange: this._onIndexNameChange,
      onIndexNameValidationStart: this.props.disableImportBtn,
      onIndexNameValidationEnd: this.props.enableImportBtn,
      onSmallChunksChange: this._onSmallChunksChange
    });
  }
}
exports.GeoUploadWizard = GeoUploadWizard;