"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gaugeRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _analytics = require("@kbn/analytics");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _common = require("../../common");
var _services = require("../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const gaugeRenderer = ({
  getStartDeps
}) => ({
  name: _common.EXPRESSION_GAUGE_NAME,
  displayName: _i18n.i18n.translate('expressionGauge.renderer.visualizationName', {
    defaultMessage: 'Gauge'
  }),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const {
      core,
      plugins
    } = getStartDeps();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const renderComplete = () => {
      let type;
      switch (config.args.shape) {
        case _common.GaugeShapes.HORIZONTAL_BULLET:
          type = `${_common.EXPRESSION_GAUGE_NAME}_horizontal`;
          break;
        case _common.GaugeShapes.VERTICAL_BULLET:
          type = `${_common.EXPRESSION_GAUGE_NAME}_vertical`;
          break;
        default:
          type = _common.EXPRESSION_GAUGE_NAME;
      }
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (containerType && visualizationType) {
        var _plugins$usageCollect;
        const events = [`render_${visualizationType}_${type}`, config.canNavigateToLens ? `render_${visualizationType}_${type}_convertable` : undefined].filter(event => Boolean(event));
        (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, events);
      }
      handlers.done();
    };
    const {
      GaugeComponent
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/gauge_component')));
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: core.theme.theme$
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "gauge-container",
      "data-test-subj": "gaugeChart"
    }, /*#__PURE__*/_react.default.createElement(GaugeComponent, (0, _extends2.default)({}, config, {
      formatFactory: (0, _services.getFormatService)().deserialize,
      chartsThemeService: plugins.charts.theme,
      paletteService: (0, _services.getPaletteService)(),
      renderComplete: renderComplete,
      uiState: handlers.uiState
    })))), domNode);
  }
});
exports.gaugeRenderer = gaugeRenderer;