"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsKPIConfig = getSyntheticsKPIConfig;
exports.isStepLevelMetric = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
var _labels = require("../constants/labels");
var _synthetics = require("../constants/field_names/synthetics");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUMMARY_UP = 'summary.up';
const SUMMARY_DOWN = 'summary.down';
const isStepLevelMetric = metric => {
  if (!metric) {
    return false;
  }
  return [_synthetics.SYNTHETICS_LCP, _synthetics.SYNTHETICS_FCP, _synthetics.SYNTHETICS_CLS, _synthetics.SYNTHETICS_DCL, _synthetics.SYNTHETICS_STEP_DURATION, _synthetics.SYNTHETICS_DOCUMENT_ONLOAD].includes(metric);
};
exports.isStepLevelMetric = isStepLevelMetric;
function getSyntheticsKPIConfig({
  dataView
}) {
  return {
    reportType: _constants.ReportTypes.KPI,
    defaultSeriesType: 'bar_stacked',
    seriesTypes: [],
    xAxisColumn: {
      sourceField: '@timestamp'
    },
    yAxisColumns: [{
      sourceField: _constants.REPORT_METRIC_FIELD,
      operationType: 'median'
    }],
    hasOperationType: true,
    filterFields: ['observer.geo.name', 'monitor.type', 'tags', 'url.full'],
    breakdownFields: ['observer.geo.name', 'monitor.type', 'monitor.name', _synthetics.SYNTHETICS_STEP_NAME, _constants.PERCENTILE],
    baseFilters: [],
    definitionFields: [{
      field: 'monitor.name',
      nested: _synthetics.SYNTHETICS_STEP_NAME,
      singleSelection: true
    }, {
      field: 'url.full',
      filters: (0, _utils.buildExistsFilter)('summary.up', dataView)
    }],
    metricOptions: [{
      label: _labels.MONITORS_DURATION_LABEL,
      field: _synthetics.MONITOR_DURATION_US,
      id: _synthetics.MONITOR_DURATION_US,
      columnType: _constants.OPERATION_COLUMN
    }, {
      label: 'Monitor availability',
      id: 'monitor_availability',
      columnType: _constants.FORMULA_COLUMN,
      formula: "1- (count(kql='summary.down > 0') / count(kql='summary: *'))"
    }, {
      label: 'Monitor Errors',
      id: 'monitor_errors',
      columnType: _constants.OPERATION_COLUMN,
      field: 'monitor.check_group',
      columnFilters: [{
        language: 'kuery',
        query: `summary.down > 0`
      }]
    }, {
      label: _i18n.i18n.translate('xpack.exploratoryView.expView.successful', {
        defaultMessage: 'Successful count'
      }),
      id: 'monitor_successful',
      field: 'monitor.check_group',
      columnType: _constants.OPERATION_COLUMN,
      columnFilters: [{
        language: 'kuery',
        query: `summary: * and summary.down: 0 and monitor.status: "up"`
      }]
    }, {
      label: 'Total runs',
      id: 'monitor.check_group',
      field: 'monitor.check_group',
      columnType: _constants.OPERATION_COLUMN,
      columnFilters: [{
        language: 'kuery',
        query: `summary: *`
      }]
    }, {
      field: SUMMARY_UP,
      id: SUMMARY_UP,
      label: _labels.UP_LABEL,
      columnType: _constants.OPERATION_COLUMN,
      palette: {
        type: 'palette',
        name: 'status'
      }
    }, {
      field: SUMMARY_DOWN,
      id: SUMMARY_DOWN,
      label: _labels.DOWN_LABEL,
      columnType: _constants.OPERATION_COLUMN,
      palette: {
        type: 'palette',
        name: 'status'
      }
    }, {
      label: _labels.STEP_DURATION_LABEL,
      field: _synthetics.SYNTHETICS_STEP_DURATION,
      id: _synthetics.SYNTHETICS_STEP_DURATION,
      columnType: _constants.OPERATION_COLUMN,
      columnFilters: [STEP_END_FILTER]
    }, {
      label: _labels.LCP_LABEL,
      field: _synthetics.SYNTHETICS_LCP,
      id: _synthetics.SYNTHETICS_LCP,
      columnType: _constants.OPERATION_COLUMN,
      columnFilters: getStepMetricColumnFilter(_synthetics.SYNTHETICS_LCP)
    }, {
      label: _labels.FCP_LABEL,
      field: _synthetics.SYNTHETICS_FCP,
      id: _synthetics.SYNTHETICS_FCP,
      columnType: _constants.OPERATION_COLUMN,
      columnFilters: getStepMetricColumnFilter(_synthetics.SYNTHETICS_FCP)
    }, {
      label: _labels.DCL_LABEL,
      field: _synthetics.SYNTHETICS_DCL,
      id: _synthetics.SYNTHETICS_DCL,
      columnType: _constants.OPERATION_COLUMN,
      columnFilters: getStepMetricColumnFilter(_synthetics.SYNTHETICS_DCL)
    }, {
      label: _labels.PAGE_LOAD_TIME_LABEL,
      field: _synthetics.SYNTHETICS_DOCUMENT_ONLOAD,
      id: _synthetics.SYNTHETICS_DOCUMENT_ONLOAD,
      columnType: _constants.OPERATION_COLUMN,
      columnFilters: getStepMetricColumnFilter(_synthetics.SYNTHETICS_DOCUMENT_ONLOAD)
    }, {
      label: _labels.CLS_LABEL,
      field: _synthetics.SYNTHETICS_CLS,
      id: _synthetics.SYNTHETICS_CLS,
      columnType: _constants.OPERATION_COLUMN,
      columnFilters: getStepMetricColumnFilter(_synthetics.SYNTHETICS_CLS)
    }, {
      label: _labels.NETWORK_TIMINGS_LABEL,
      id: 'network_timings',
      columnType: _constants.OPERATION_COLUMN,
      items: _synthetics.NETWORK_TIMINGS_FIELDS.map(field => {
        var _FieldLabels$field;
        return {
          label: (_FieldLabels$field = _constants.FieldLabels[field]) !== null && _FieldLabels$field !== void 0 ? _FieldLabels$field : field,
          field,
          id: field,
          columnType: _constants.OPERATION_COLUMN,
          columnFilters: getStepMetricColumnFilter(field, 'journey/network_info')
        };
      })
    }],
    labels: {
      ..._constants.FieldLabels,
      [SUMMARY_UP]: _labels.UP_LABEL,
      [SUMMARY_DOWN]: _labels.DOWN_LABEL
    }
  };
}
const getStepMetricColumnFilter = (field, stepType = 'step/metrics') => {
  return [{
    language: 'kuery',
    query: `synthetics.type: ${stepType} and ${field}: * and ${field} > 0`
  }];
};
const STEP_END_FILTER = {
  language: 'kuery',
  query: `synthetics.type: step/end`
};