"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCoreWebVitalsConfig = getCoreWebVitalsConfig;
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _utils = require("../utils");
var _elasticsearch_fieldnames = require("../constants/elasticsearch_fieldnames");
var _labels = require("../constants/labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getCoreWebVitalsConfig({
  dataView
}) {
  const statusPallete = (0, _eui.euiPaletteForStatus)(3);
  return {
    defaultSeriesType: 'bar_horizontal_percentage_stacked',
    reportType: _constants.ReportTypes.CORE_WEB_VITAL,
    seriesTypes: ['bar_horizontal_percentage_stacked'],
    xAxisColumn: {
      sourceField: _constants.USE_BREAK_DOWN_COLUMN
    },
    yAxisColumns: [{
      sourceField: _constants.REPORT_METRIC_FIELD,
      label: 'Good'
    }, {
      sourceField: _constants.REPORT_METRIC_FIELD,
      label: 'Average'
    }, {
      sourceField: _constants.REPORT_METRIC_FIELD,
      label: 'Poor'
    }],
    hasOperationType: false,
    filterFields: [{
      field: _elasticsearch_fieldnames.TRANSACTION_URL,
      isNegated: false
    }, _elasticsearch_fieldnames.SERVICE_NAME, {
      field: _elasticsearch_fieldnames.USER_AGENT_OS,
      nested: _elasticsearch_fieldnames.USER_AGENT_OS_VERSION
    }, _elasticsearch_fieldnames.CLIENT_GEO_COUNTRY_NAME, _elasticsearch_fieldnames.USER_AGENT_DEVICE, {
      field: _elasticsearch_fieldnames.USER_AGENT_NAME,
      nested: _elasticsearch_fieldnames.USER_AGENT_VERSION
    }, _constants.LABEL_FIELDS_FILTER],
    breakdownFields: [_elasticsearch_fieldnames.SERVICE_NAME, _elasticsearch_fieldnames.USER_AGENT_NAME, _elasticsearch_fieldnames.USER_AGENT_OS, _elasticsearch_fieldnames.CLIENT_GEO_COUNTRY_NAME, _elasticsearch_fieldnames.USER_AGENT_DEVICE, _elasticsearch_fieldnames.URL_FULL],
    baseFilters: [...(0, _utils.buildPhraseFilter)(_elasticsearch_fieldnames.TRANSACTION_TYPE, 'page-load', dataView), ...(0, _utils.buildPhraseFilter)(_elasticsearch_fieldnames.PROCESSOR_EVENT, 'transaction', dataView)],
    labels: {
      ..._constants.FieldLabels,
      [_elasticsearch_fieldnames.SERVICE_NAME]: 'Web Application'
    },
    definitionFields: [_elasticsearch_fieldnames.SERVICE_NAME, _elasticsearch_fieldnames.SERVICE_ENVIRONMENT],
    metricOptions: [{
      id: _elasticsearch_fieldnames.LCP_FIELD,
      label: _labels.LCP_LABEL,
      columnType: _constants.FILTER_RECORDS,
      columnFilters: [{
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.LCP_FIELD} < 2500`
      }, {
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.LCP_FIELD} > 2500 and ${_elasticsearch_fieldnames.LCP_FIELD} < 4000`
      }, {
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.LCP_FIELD} > 4000`
      }]
    }, {
      label: _labels.FID_LABEL,
      id: _elasticsearch_fieldnames.FID_FIELD,
      columnType: _constants.FILTER_RECORDS,
      columnFilters: [{
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.FID_FIELD} < 100`
      }, {
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.FID_FIELD} > 100 and ${_elasticsearch_fieldnames.FID_FIELD} < 300`
      }, {
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.FID_FIELD} > 300`
      }]
    }, {
      label: _labels.CLS_LABEL,
      id: _elasticsearch_fieldnames.CLS_FIELD,
      columnType: _constants.FILTER_RECORDS,
      columnFilters: [{
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.CLS_FIELD} < 0.1`
      }, {
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.CLS_FIELD} > 0.1 and ${_elasticsearch_fieldnames.CLS_FIELD} < 0.25`
      }, {
        language: 'kuery',
        query: `${_elasticsearch_fieldnames.CLS_FIELD} > 0.25`
      }]
    }],
    yConfig: [{
      color: statusPallete[0],
      forAccessor: 'y-axis-column'
    }, {
      color: statusPallete[1],
      forAccessor: 'y-axis-column-1'
    }, {
      color: statusPallete[2],
      forAccessor: 'y-axis-column-2'
    }],
    query: {
      query: 'transaction.type: "page-load"',
      language: 'kuery'
    }
  };
}