"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeatMapLensAttributes = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _single_metric_attributes = require("./single_metric_attributes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class HeatMapLensAttributes extends _single_metric_attributes.SingleMetricLensAttributes {
  constructor(layerConfigs, reportType, lensFormulaHelper) {
    super(layerConfigs, reportType, lensFormulaHelper);
    (0, _defineProperty2.default)(this, "xColumnId", void 0);
    (0, _defineProperty2.default)(this, "layerId", void 0);
    (0, _defineProperty2.default)(this, "breakDownColumnId", void 0);
    this.xColumnId = 'layer-0-column-x-1';
    this.breakDownColumnId = 'layer-0-breakdown-column';
    this.layerId = 'layer0';
    const layer0 = this.getSingleMetricLayer();
    layer0.columns[this.xColumnId] = this.getDateHistogramColumn('@timestamp');
    let columnOrder = [this.xColumnId];
    const layerConfig = layerConfigs[0];
    if (layerConfig.breakdown) {
      columnOrder = [this.breakDownColumnId, ...columnOrder];
      layer0.columns[this.breakDownColumnId] = this.getBreakdownColumn({
        layerConfig,
        sourceField: layerConfig.breakdown,
        layerId: this.layerId,
        alphabeticOrder: true
      });
    }
    layer0.columnOrder = [...columnOrder, ...layer0.columnOrder];
    this.layers = {
      layer0
    };
    this.visualization = this.getHeatmapState();
  }
  getHeatmapState() {
    const negativePalette = (0, _eui.euiPaletteNegative)(5);
    const layerConfig = this.layerConfigs[0];
    return {
      shape: 'heatmap',
      layerId: this.layerId,
      layerType: 'data',
      legend: {
        isVisible: true,
        position: 'right',
        type: 'heatmap_legend'
      },
      gridConfig: {
        type: 'heatmap_grid',
        isCellLabelVisible: false,
        isYAxisLabelVisible: true,
        isXAxisLabelVisible: true,
        isYAxisTitleVisible: false,
        isXAxisTitleVisible: false,
        xTitle: ''
      },
      valueAccessor: this.columnId,
      xAccessor: this.xColumnId,
      yAccessor: layerConfig.breakdown ? this.breakDownColumnId : undefined,
      palette: {
        type: 'palette',
        name: 'negative',
        params: {
          name: 'negative',
          continuity: 'above',
          reverse: false,
          stops: negativePalette.map((nColor, ind) => ({
            color: nColor,
            stop: ind === 0 ? 1 : ind * 20
          })),
          rangeMin: 0
        },
        accessor: this.columnId
      }
    };
  }
}
exports.HeatMapLensAttributes = HeatMapLensAttributes;