"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventAnnotationServerPlugin = void 0;
var _common = require("../common");
var _saved_objects = require("./saved_objects");
var _content_management = require("./content_management");
var _content_management2 = require("../common/content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class EventAnnotationServerPlugin {
  setup(core, dependencies) {
    dependencies.expressions.registerFunction(_common.manualPointEventAnnotation);
    dependencies.expressions.registerFunction(_common.manualRangeEventAnnotation);
    dependencies.expressions.registerFunction(_common.queryPointEventAnnotation);
    dependencies.expressions.registerFunction(_common.eventAnnotationGroup);
    (0, _saved_objects.setupSavedObjects)(core);
    dependencies.contentManagement.register({
      id: _content_management2.CONTENT_ID,
      storage: new _content_management.EventAnnotationGroupStorage(),
      version: {
        latest: _content_management2.LATEST_VERSION
      }
    });
    return {};
  }
  start() {
    return {};
  }
  stop() {}
}
exports.EventAnnotationServerPlugin = EventAnnotationServerPlugin;