"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupEditorFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _group_editor_controls = require("./group_editor_controls");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const GroupEditorFlyout = ({
  group,
  updateGroup,
  onClose: parentOnClose,
  onSave,
  savedObjectsTagging,
  dataViews,
  createDataView,
  queryInputServices
}) => {
  const flyoutHeadingId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const flyoutBodyOverflowRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (!flyoutBodyOverflowRef.current) {
      flyoutBodyOverflowRef.current = document.querySelector('.euiFlyoutBody__overflow');
    }
  }, []);
  const [hasAttemptedSave, setHasAttemptedSave] = (0, _react.useState)(false);
  const resetContentScroll = (0, _react.useCallback)(() => flyoutBodyOverflowRef.current && flyoutBodyOverflowRef.current.scroll(0, 0), []);
  const [selectedAnnotation, _setSelectedAnnotation] = (0, _react.useState)();
  const setSelectedAnnotation = (0, _react.useCallback)(newValue => {
    if (!newValue && selectedAnnotation || newValue && !selectedAnnotation) resetContentScroll();
    _setSelectedAnnotation(newValue);
  }, [resetContentScroll, selectedAnnotation]);
  const onClose = () => selectedAnnotation ? setSelectedAnnotation(undefined) : parentOnClose();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: 's'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "aria-labelledby": flyoutHeadingId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutHeadingId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotation.groupEditorFlyout.title",
    defaultMessage: "Edit annotation group"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_group_editor_controls.GroupEditorControls, {
    group: group,
    update: updateGroup,
    selectedAnnotation: selectedAnnotation,
    setSelectedAnnotation: setSelectedAnnotation,
    TagSelector: savedObjectsTagging.ui.components.SavedObjectSaveModalTagSelector,
    dataViews: dataViews,
    createDataView: createDataView,
    queryInputServices: queryInputServices,
    showValidation: hasAttemptedSave
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, selectedAnnotation ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    "data-test-subj": "backToGroupSettings",
    onClick: () => setSelectedAnnotation(undefined)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotation.edit.back",
    defaultMessage: "Back"
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelGroupEdit",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotation.edit.cancel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "save",
    "data-test-subj": "saveAnnotationGroup",
    fill: true,
    onClick: () => {
      setHasAttemptedSave(true);
      if ((0, _group_editor_controls.isGroupValid)(group)) {
        onSave();
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotation.edit.save",
    defaultMessage: "Save annotation group"
  })))))));
};
exports.GroupEditorFlyout = GroupEditorFlyout;