"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isGroupValid = exports.GroupEditorControls = exports.ENABLE_INDIVIDUAL_ANNOTATION_EDITING = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = _interopRequireWildcard(require("react"));
var _constants = require("../../../common/constants");
var _annotation_editor_controls = require("../annotation_editor_controls");
var _annotation_list = require("./annotation_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ENABLE_INDIVIDUAL_ANNOTATION_EDITING = false;
exports.ENABLE_INDIVIDUAL_ANNOTATION_EDITING = ENABLE_INDIVIDUAL_ANNOTATION_EDITING;
const isTitleValid = title => Boolean(title.length);
const isGroupValid = group => isTitleValid(group.title);
exports.isGroupValid = isGroupValid;
const GroupEditorControls = ({
  group,
  update,
  setSelectedAnnotation: _setSelectedAnnotation,
  selectedAnnotation,
  TagSelector,
  dataViews: globalDataViews,
  createDataView,
  queryInputServices,
  showValidation
}) => {
  // save the spec for the life of the component since the user might change their mind after selecting another data view
  const [adHocDataView, setAdHocDataView] = (0, _react2.useState)();
  (0, _react2.useEffect)(() => {
    if (group.dataViewSpec) {
      createDataView(group.dataViewSpec).then(setAdHocDataView);
    }
  }, [createDataView, group.dataViewSpec]);
  const setSelectedAnnotation = (0, _react2.useCallback)(newSelection => {
    update({
      ...group,
      annotations: group.annotations.map(annotation => annotation.id === newSelection.id ? newSelection : annotation)
    });
    _setSelectedAnnotation(newSelection);
  }, [_setSelectedAnnotation, group, update]);
  const dataViews = (0, _react2.useMemo)(() => {
    const items = [...globalDataViews];
    if (adHocDataView) {
      items.push(adHocDataView);
    }
    return items;
  }, [adHocDataView, globalDataViews]);
  const currentDataView = (0, _react2.useMemo)(() => dataViews.find(dataView => dataView.id === group.indexPatternId) || dataViews[0], [dataViews, group.indexPatternId]);
  return !selectedAnnotation ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xs",
    css: (0, _react.css)`
          margin-bottom: ${_uiTheme.euiThemeVars.euiSize};
        `
  }, /*#__PURE__*/_react2.default.createElement("h4", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotation.groupEditor.details",
    defaultMessage: "Details"
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotation.groupEditor.title', {
      defaultMessage: 'Title'
    }),
    isInvalid: showValidation && !isTitleValid(group.title),
    error: _i18n.i18n.translate('eventAnnotation.groupEditor.titleRequired', {
      defaultMessage: 'A title is required.'
    })
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "annotationGroupTitle",
    value: group.title,
    isInvalid: showValidation && !isTitleValid(group.title),
    onChange: ({
      target: {
        value
      }
    }) => update({
      ...group,
      title: value
    })
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotation.groupEditor.description', {
      defaultMessage: 'Description'
    }),
    labelAppend: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotation.groupEditor.optional",
      defaultMessage: "Optional"
    }))
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": "annotationGroupDescription",
    value: group.description,
    onChange: ({
      target: {
        value
      }
    }) => update({
      ...group,
      description: value
    })
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react2.default.createElement(TagSelector, {
    initialSelection: group.tags,
    markOptional: true,
    onTagsSelected: tags => update({
      ...group,
      tags
    })
  })), ENABLE_INDIVIDUAL_ANNOTATION_EDITING && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotation.groupEditor.dataView', {
      defaultMessage: 'Data view'
    })
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "annotationDataViewSelection",
    options: dataViews.map(({
      id: value,
      title,
      name
    }) => ({
      value,
      text: name !== null && name !== void 0 ? name : title
    })),
    value: group.indexPatternId,
    onChange: ({
      target: {
        value
      }
    }) => update({
      ...group,
      indexPatternId: value,
      dataViewSpec: value === (adHocDataView === null || adHocDataView === void 0 ? void 0 : adHocDataView.id) ? adHocDataView.toSpec(false) : undefined
    })
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotation.groupEditor.addAnnotation', {
      defaultMessage: 'Annotations'
    })
  }, /*#__PURE__*/_react2.default.createElement(_annotation_list.AnnotationList, {
    annotations: group.annotations,
    selectAnnotation: setSelectedAnnotation,
    update: newAnnotations => update({
      ...group,
      annotations: newAnnotations
    })
  }))))) : /*#__PURE__*/_react2.default.createElement(_annotation_editor_controls.AnnotationEditorControls, {
    annotation: selectedAnnotation,
    onAnnotationChange: changes => setSelectedAnnotation({
      ...selectedAnnotation,
      ...changes
    }),
    dataView: currentDataView,
    getDefaultRangeEnd: rangeStart => rangeStart,
    queryInputServices: queryInputServices,
    appName: _constants.EVENT_ANNOTATION_APP_NAME
  });
};
exports.GroupEditorControls = GroupEditorControls;