"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnnotationAccessor = void 0;
var _helpers = require("../event_annotation_service/helpers");
var _icon_set = require("./annotation_editor_controls/icon_set");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getAnnotationAccessor = annotation => {
  var _annotationIcon$icon;
  const annotationIcon = !(0, _helpers.isRangeAnnotationConfig)(annotation) ? _icon_set.annotationsIconSet.find(option => option.value === (annotation === null || annotation === void 0 ? void 0 : annotation.icon)) || _icon_set.annotationsIconSet.find(option => option.value === 'triangle') : undefined;
  const icon = (_annotationIcon$icon = annotationIcon === null || annotationIcon === void 0 ? void 0 : annotationIcon.icon) !== null && _annotationIcon$icon !== void 0 ? _annotationIcon$icon : annotationIcon === null || annotationIcon === void 0 ? void 0 : annotationIcon.value;
  return {
    columnId: annotation.id,
    triggerIconType: annotation.isHidden ? 'invisible' : icon ? 'custom' : 'color',
    customIcon: icon,
    color: (annotation === null || annotation === void 0 ? void 0 : annotation.color) || ((0, _helpers.isRangeAnnotationConfig)(annotation) ? _helpers.defaultAnnotationRangeColor : _helpers.defaultAnnotationColor)
  };
};
exports.getAnnotationAccessor = getAnnotationAccessor;