"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.revertCustomPipeline = void 0;
var _ = require("../..");
var _fetch_connectors = require("../connectors/fetch_connectors");
var _delete_pipelines = require("./delete_pipelines");
var _get_default_pipeline = require("./get_default_pipeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const revertCustomPipeline = async (client, indexName) => {
  const connector = await (0, _fetch_connectors.fetchConnectorByIndexName)(client, indexName);
  if (connector) {
    const pipeline = await (0, _get_default_pipeline.getDefaultPipeline)(client);
    await client.asCurrentUser.update({
      doc: {
        pipeline
      },
      id: connector === null || connector === void 0 ? void 0 : connector.id,
      index: _.CONNECTORS_INDEX
    });
  }
  return await (0, _delete_pipelines.deleteIndexPipelines)(client, indexName);
};
exports.revertCustomPipeline = revertCustomPipeline;