"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.putUpdateNative = void 0;
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const putUpdateNative = async (client, connectorId, isNative) => {
  const result = await client.asCurrentUser.update({
    doc: {
      is_native: isNative
    },
    id: connectorId,
    index: _.CONNECTORS_INDEX
  });
  return result;
};
exports.putUpdateNative = putUpdateNative;