"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeysList = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../shared/constants");
var _hidden_text = require("../../../../shared/hidden_text");
var _table_pagination = require("../../../../shared/table_pagination");
var _api_keys_logic = require("../api_keys_logic");
var _constants2 = require("../constants");
var _api_key = require("./api_key");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiKeysList = () => {
  const {
    deleteApiKey,
    onPaginate,
    stageTokenNameForDeletion,
    hideDeleteModal
  } = (0, _kea.useActions)(_api_keys_logic.ApiKeysLogic);
  const {
    apiTokens,
    meta,
    dataLoading,
    deleteModalVisible
  } = (0, _kea.useValues)(_api_keys_logic.ApiKeysLogic);
  const deleteModal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _constants2.API_KEYS_CONFIRM_DELETE_TITLE,
    onCancel: hideDeleteModal,
    onConfirm: deleteApiKey,
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: _constants.DELETE_BUTTON_LABEL,
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants2.API_KEYS_CONFIRM_DELETE_LABEL));
  const columns = [{
    name: _constants2.NAME_TITLE,
    render: token => token.name
  }, {
    name: _constants2.KEY_TITLE,
    className: 'eui-textBreakAll',
    render: token => {
      const {
        key
      } = token;
      if (!key) return null;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
        textToCopy: key,
        afterMessage: _constants2.COPIED_TOOLTIP
      }, copy => /*#__PURE__*/_react.default.createElement(_hidden_text.HiddenText, {
        text: key
      }, ({
        hiddenText,
        isHidden,
        toggle
      }) => /*#__PURE__*/_react.default.createElement(_api_key.ApiKey, {
        copy: copy,
        toggleIsHidden: toggle,
        isHidden: isHidden,
        text: hiddenText
      })));
    },
    mobileOptions: {
      width: '100%'
    }
  }, {
    actions: [{
      name: _constants.DELETE_BUTTON_LABEL,
      description: _constants2.DELETE_API_KEY_BUTTON_DESCRIPTION,
      type: 'icon',
      icon: 'trash',
      color: 'danger',
      onClick: token => stageTokenNameForDeletion(token.name)
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deleteModalVisible && deleteModal, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: apiTokens,
    loading: dataLoading,
    pagination: {
      ...(0, _table_pagination.convertMetaToPagination)(meta),
      showPerPageOptions: false
    },
    onChange: (0, _table_pagination.handlePageChange)(onPaginate)
  }));
};
exports.ApiKeysList = ApiKeysList;