"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _kibana_logic = require("../../../shared/kibana/kibana_logic");
var _layout = require("../../components/layout");
var _constants = require("../../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AccountSettings = () => {
  const {
    security
  } = (0, _kea.useValues)(_kibana_logic.KibanaLogic);
  const [currentUser, setCurrentUser] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    security.authc.getCurrentUser().then(setCurrentUser).catch(() => {
      setCurrentUser(null);
    });
  }, [security.authc]);
  const PersonalInfo = (0, _react.useMemo)(() => security.uiApi.components.getPersonalInfo, [security.uiApi]);
  const ChangePassword = (0, _react.useMemo)(() => security.uiApi.components.getChangePassword, [security.uiApi]);
  if (!currentUser) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_layout.PersonalDashboardLayout, {
    pageChrome: [_constants.ACCOUNT_SETTINGS_TITLE]
  }, /*#__PURE__*/_react.default.createElement(PersonalInfo, {
    user: currentUser
  }), /*#__PURE__*/_react.default.createElement(ChangePassword, {
    user: currentUser
  }));
};
exports.AccountSettings = AccountSettings;