"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CredentialItem = exports.COPY_TOOLTIP = exports.COPIED_TOOLTIP = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COPY_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.credentialItem.copy.tooltip', {
  defaultMessage: 'Copy to clipboard'
});
exports.COPY_TOOLTIP = COPY_TOOLTIP;
const COPIED_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.credentialItem.copied.tooltip', {
  defaultMessage: 'Copied!'
});
exports.COPIED_TOOLTIP = COPIED_TOOLTIP;
const inputSelectAll = e => e.currentTarget.select();
const CredentialItem = ({
  label,
  value,
  testSubj,
  hideCopy
}) => {
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const SHOW_CREDENTIAL_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.credentialItem.show.tooltip', {
    defaultMessage: 'Show {credential}.',
    values: {
      credential: label
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    "data-test-subj": testSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, !hideCopy && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: COPY_TOOLTIP,
    afterMessage: COPIED_TOOLTIP,
    textToCopy: value
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": COPY_TOOLTIP,
    onClick: copy,
    iconType: "copy",
    color: "primary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: SHOW_CREDENTIAL_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": SHOW_CREDENTIAL_TOOLTIP,
    "data-test-subj": `Show${(0, _lodash.upperFirst)(testSubj)}`,
    onClick: () => setIsVisible(!isVisible),
    iconType: isVisible ? 'eyeClosed' : 'eye',
    color: "primary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, !isVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    placeholder: label,
    value: value,
    readOnly: true,
    compressed: true,
    disabled: true
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    readOnly: true,
    placeholder: "Compressed",
    "data-test-subj": `${testSubj}Input`,
    value: value,
    compressed: true,
    onClick: inputSelectAll
  })))));
};
exports.CredentialItem = CredentialItem;