"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorSearchGuide = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _elser = _interopRequireDefault(require("../../../../assets/images/elser.svg"));
var _nlp = _interopRequireDefault(require("../../../../assets/images/nlp.svg"));
var _doc_links = require("../../../shared/doc_links");
var _kibana = require("../../../shared/kibana");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _dev_tools_console_code_block = require("../dev_tools_console_code_block/dev_tools_console_code_block");
var _page_template = require("../layout/page_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREATE_INDEX_SNIPPET = `PUT /image-index
{
  "mappings": {
    "properties": {
      "image-vector": {
        "type": "dense_vector",
        "dims": 3,
        "index": true,
        "similarity": "l2_norm"
      },
      "title-vector": {
        "type": "dense_vector",
        "dims": 5,
        "index": true,
        "similarity": "l2_norm"
      },
      "title": {
        "type": "text"
      },
      "file-type": {
        "type": "keyword"
      }
    }
  }
}`;
const INGEST_SNIPPET = `POST /image-index/_bulk?refresh=true
{ "index": { "_id": "1" } }
{ "image-vector": [1, 5, -20], "title-vector": [12, 50, -10, 0, 1], "title": "moose family", "file-type": "jpg" }
{ "index": { "_id": "2" } }
{ "image-vector": [42, 8, -15], "title-vector": [25, 1, 4, -12, 2], "title": "alpine lake", "file-type": "png" }
{ "index": { "_id": "3" } }
{ "image-vector": [15, 11, 23], "title-vector": [1, 5, 25, 50, 20], "title": "full moon", "file-type": "jpg" }`;
const QUERY_SNIPPET = `POST /image-index/_search
{
  "knn": {
    "field": "image-vector",
    "query_vector": [-5, 9, -12],
    "k": 10,
    "num_candidates": 100
  },
  "fields": [ "title", "file-type" ]
}`;
const VectorSearchGuide = () => {
  const {
    application
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchVectorSearchPageTemplate, {
    restrictWidth: true,
    pageHeader: {
      description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.vectorSearch.guide.description",
        defaultMessage: "Elasticsearch can be used as a vector database, which enables vector search and semantic search use cases."
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.knnSearch,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.vectorSearch.guide.descriptionLink",
        defaultMessage: "Learn more about vector search."
      }))),
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.vectorSearch.guide.pageTitle",
        defaultMessage: "Get started with vector search"
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetVectorSearchChrome, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.createIndex.title",
    defaultMessage: "Create an index"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.createIndex.description",
    defaultMessage: "Start by creating an index with one or more {denseVector} fields.",
    values: {
      denseVector: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "dense_vector")
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_dev_tools_console_code_block.DevToolsConsoleCodeBlock, null, CREATE_INDEX_SNIPPET))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.ingest.title",
    defaultMessage: "Ingest your data"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.ingest.description",
    defaultMessage: "Add data to your index to make it searchable."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_dev_tools_console_code_block.DevToolsConsoleCodeBlock, null, INGEST_SNIPPET))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.query.title",
    defaultMessage: "Build your vector search query"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.query.description",
    defaultMessage: "Now you're ready to explore your data with searches and aggregations."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_dev_tools_console_code_block.DevToolsConsoleCodeBlock, null, QUERY_SNIPPET))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.deployedModel.title",
    defaultMessage: "Don\u2019t have a model deployed?"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.deployedModel.description",
    defaultMessage: "Elastic can help you generate embeddings."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    onClick: () => application.navigateToApp(_constants.ESRE_PLUGIN.URL.replace(/^(?:\/app\/)?(.*)$/, '$1')),
    layout: "horizontal",
    titleSize: "s",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _elser.default,
      size: "xxl"
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.vectorSearch.guide.deployedModel.elser.title",
      defaultMessage: "Elastic Learned Sparse Encoder (ELSER)"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.vectorSearch.guide.deployedModel.elser.description",
      defaultMessage: "Learn about our model that enables semantic search without configuration"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    href: _doc_links.docLinks.textEmbedding,
    target: "_blank",
    layout: "horizontal",
    titleSize: "s",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _nlp.default,
      size: "xxl"
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.vectorSearch.guide.deployedModel.byoModel.title",
      defaultMessage: "Run your models in Elastic"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.vectorSearch.guide.deployedModel.byoModel.description",
      defaultMessage: "Learn how to upload compatible third-party models"
    })
  })))));
};
exports.VectorSearchGuide = VectorSearchGuide;