"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntSearchLogStream = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/infra-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntSearchLogStream = ({
  startTimestamp,
  endTimestamp,
  hoursAgo = 24,
  ...props
}) => {
  if (!endTimestamp) endTimestamp = Date.now();
  if (!startTimestamp) startTimestamp = endTimestamp - hoursAgo * 60 * 60 * 1000;
  return /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, null, /*#__PURE__*/_react.default.createElement(_public.LogStream, (0, _extends2.default)({
    startTimestamp: startTimestamp,
    endTimestamp: endTimestamp
  }, props)));
};
exports.EntSearchLogStream = EntSearchLogStream;