"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWorkplaceSearchUrl = exports.getEnterpriseSearchUrl = exports.getAppSearchUrl = exports.externalUrl = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * NOTE: The externalUrl obj holds the reference to externalUrl, which should
 * only ever be updated once on plugin init. We're using a getter and setter
 * here to ensure it isn't accidentally mutated.
 *
 * Someday (8.x+), when our UI is entirely on Kibana and no longer on
 * Enterprise Search's standalone UI, we can potentially deprecate this helper.
 */
const externalUrl = {
  _enterpriseSearchUrl: '',
  get enterpriseSearchUrl() {
    return this._enterpriseSearchUrl;
  },
  set enterpriseSearchUrl(value) {
    if (this._enterpriseSearchUrl) {
      // enterpriseSearchUrl is set once on plugin init - we should not mutate it
      return;
    }
    this._enterpriseSearchUrl = value;
  }
};
exports.externalUrl = externalUrl;
const getEnterpriseSearchUrl = (path = '') => {
  return externalUrl.enterpriseSearchUrl + path;
};
exports.getEnterpriseSearchUrl = getEnterpriseSearchUrl;
const getAppSearchUrl = (path = '') => {
  return getEnterpriseSearchUrl('/as' + path);
};
exports.getAppSearchUrl = getAppSearchUrl;
const getWorkplaceSearchUrl = (path = '') => {
  return getEnterpriseSearchUrl('/ws' + path);
};
exports.getWorkplaceSearchUrl = getWorkplaceSearchUrl;