"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchCronEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _cron_editor = require("./cron_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchCronEditor = ({
  disabled,
  onChange,
  scheduling
}) => {
  var _scheduling$interval;
  const [fieldToPreferredValueMap, setFieldToPreferredValueMap] = (0, _react.useState)({});
  const [simpleCron, setSimpleCron] = (0, _react.useState)({
    expression: (_scheduling$interval = scheduling === null || scheduling === void 0 ? void 0 : scheduling.interval) !== null && _scheduling$interval !== void 0 ? _scheduling$interval : '',
    frequency: scheduling !== null && scheduling !== void 0 && scheduling.interval ? cronToFrequency(scheduling.interval) : 'HOUR'
  });
  return /*#__PURE__*/_react.default.createElement(_cron_editor.CronEditor, {
    fieldToPreferredValueMap: fieldToPreferredValueMap,
    cronExpression: simpleCron.expression,
    frequency: simpleCron.frequency,
    disabled: disabled,
    onChange: ({
      cronExpression: expression,
      frequency,
      fieldToPreferredValueMap: newFieldToPreferredValueMap
    }) => {
      setSimpleCron({
        expression,
        frequency
      });
      setFieldToPreferredValueMap(newFieldToPreferredValueMap);
      onChange({
        ...scheduling,
        interval: expression
      });
    },
    frequencyBlockList: ['MINUTE']
  });
};
exports.EnterpriseSearchCronEditor = EnterpriseSearchCronEditor;
function cronToFrequency(cron) {
  const fields = cron.split(' ');
  if (fields.length < 4) {
    return 'YEAR';
  }
  if (fields[1] === '*') {
    return 'MINUTE';
  }
  if (fields[2] === '*') {
    return 'HOUR';
  }
  if (fields[3] === '*') {
    return 'DAY';
  }
  if (fields[4] === '*') {
    return 'WEEK';
  }
  if (fields[4] === '?') {
    return 'MONTH';
  }
  return 'YEAR';
}