"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CronEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("./constants");
var _cron_daily = require("./cron_daily");
var _cron_hourly = require("./cron_hourly");
var _cron_minutely = require("./cron_minutely");
var _cron_monthly = require("./cron_monthly");
var _cron_weekly = require("./cron_weekly");
var _cron_yearly = require("./cron_yearly");
var _services = require("./services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const excludeBlockListedFrequencies = (units, blockListedUnits = []) => {
  if (blockListedUnits.length === 0) {
    return units;
  }
  return units.filter(({
    value
  }) => !blockListedUnits.includes(value));
};
class CronEditor extends _react.Component {
  static getDerivedStateFromProps(props) {
    const {
      cronExpression
    } = props;
    return (0, _services.cronExpressionToParts)(cronExpression);
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onChangeFrequency", frequency => {
      const {
        onChange,
        fieldToPreferredValueMap
      } = this.props;

      // Update fields which aren't editable with acceptable baseline values.
      const editableFields = Object.keys(_constants.frequencyToFieldsMap[frequency]);
      const inheritedFields = editableFields.reduce((fieldBaselines, field) => {
        if (fieldToPreferredValueMap[field] != null) {
          fieldBaselines[field] = fieldToPreferredValueMap[field];
        }
        return fieldBaselines;
      }, {
        ..._constants.frequencyToBaselineFieldsMap[frequency]
      });
      const newCronExpression = (0, _services.cronPartsToExpression)(inheritedFields);
      onChange({
        frequency,
        cronExpression: newCronExpression,
        fieldToPreferredValueMap
      });
    });
    (0, _defineProperty2.default)(this, "onChangeFields", fields => {
      const {
        onChange,
        frequency,
        fieldToPreferredValueMap
      } = this.props;
      const editableFields = Object.keys(_constants.frequencyToFieldsMap[frequency]);
      const newFieldToPreferredValueMap = {};
      const editedFields = editableFields.reduce((accumFields, field) => {
        if (fields[field] !== undefined) {
          accumFields[field] = fields[field];
          // If the user changes a field's value, we want to maintain that value in the relevant
          // field, even as the frequency field changes. For example, if the user selects "Monthly"
          // frequency and changes the "Hour" field to "10", that field should still say "10" if the
          // user changes the frequency to "Weekly". We'll support this UX by storing these values
          // in the fieldToPreferredValueMap.
          newFieldToPreferredValueMap[field] = fields[field];
        } else {
          accumFields[field] = this.state[field];
        }
        return accumFields;
      }, {
        ..._constants.frequencyToBaselineFieldsMap[frequency]
      });
      const newCronExpression = (0, _services.cronPartsToExpression)(editedFields);
      onChange({
        frequency,
        cronExpression: newCronExpression,
        fieldToPreferredValueMap: {
          ...fieldToPreferredValueMap,
          ...newFieldToPreferredValueMap
        }
      });
    });
    const {
      cronExpression
    } = props;
    const parsedCron = (0, _services.cronExpressionToParts)(cronExpression);
    this.state = {
      ...parsedCron
    };
  }
  renderForm() {
    const {
      frequency,
      disabled
    } = this.props;
    const {
      minute,
      hour,
      day,
      date,
      month
    } = this.state;
    switch (frequency) {
      case 'MINUTE':
        return /*#__PURE__*/_react.default.createElement(_cron_minutely.CronMinutely, {
          disabled: disabled,
          minute: minute,
          minuteOptions: _constants.EVERY_MINUTE_OPTIONS,
          onChange: this.onChangeFields
        });
      case 'HOUR':
        return /*#__PURE__*/_react.default.createElement(_cron_hourly.CronHourly, {
          disabled: disabled,
          minute: minute,
          minuteOptions: _constants.MINUTE_OPTIONS,
          onChange: this.onChangeFields
        });
      case 'DAY':
        return /*#__PURE__*/_react.default.createElement(_cron_daily.CronDaily, {
          disabled: disabled,
          minute: minute,
          minuteOptions: _constants.MINUTE_OPTIONS,
          hour: hour,
          hourOptions: _constants.HOUR_OPTIONS,
          onChange: this.onChangeFields
        });
      case 'WEEK':
        return /*#__PURE__*/_react.default.createElement(_cron_weekly.CronWeekly, {
          disabled: disabled,
          minute: minute,
          minuteOptions: _constants.MINUTE_OPTIONS,
          hour: hour,
          hourOptions: _constants.HOUR_OPTIONS,
          day: day,
          dayOptions: _constants.DAY_OPTIONS,
          onChange: this.onChangeFields
        });
      case 'MONTH':
        return /*#__PURE__*/_react.default.createElement(_cron_monthly.CronMonthly, {
          disabled: disabled,
          minute: minute,
          minuteOptions: _constants.MINUTE_OPTIONS,
          hour: hour,
          hourOptions: _constants.HOUR_OPTIONS,
          date: date,
          dateOptions: _constants.DATE_OPTIONS,
          onChange: this.onChangeFields
        });
      case 'YEAR':
        return /*#__PURE__*/_react.default.createElement(_cron_yearly.CronYearly, {
          disabled: disabled,
          minute: minute,
          minuteOptions: _constants.MINUTE_OPTIONS,
          hour: hour,
          hourOptions: _constants.HOUR_OPTIONS,
          date: date,
          dateOptions: _constants.DATE_OPTIONS,
          month: month,
          monthOptions: _constants.MONTH_OPTIONS,
          onChange: this.onChangeFields
        });
      default:
        return;
    }
  }
  render() {
    const {
      disabled,
      frequency,
      frequencyBlockList
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.cronEditor.fieldFrequencyLabel",
        defaultMessage: "Frequency"
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      disabled: disabled,
      autoFocus: this.props.autoFocus,
      options: excludeBlockListedFrequencies(_constants.UNITS, frequencyBlockList),
      value: frequency,
      onChange: e => this.onChangeFrequency(e.target.value),
      fullWidth: true,
      prepend: _i18n.i18n.translate('xpack.enterpriseSearch.cronEditor.textEveryLabel', {
        defaultMessage: 'Every'
      }),
      "data-test-subj": "cronFrequencySelect"
    })), this.renderForm());
  }
}
exports.CronEditor = CronEditor;