"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../shared/kibana");
var _index_view_logic = require("../index_view_logic");
var _sync_jobs_history_table = require("./sync_jobs_history_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncJobs = () => {
  const {
    hasDocumentLevelSecurityFeature
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    productFeatures
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const [selectedSyncJobCategory, setSelectedSyncJobCategory] = (0, _react.useState)('content');
  const shouldShowAccessSyncs = productFeatures.hasDocumentLevelSecurityEnabled && hasDocumentLevelSecurityFeature;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowAccessSyncs && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.enterpriseSearch.content.syncJobs.lastSync.tableSelector.legend', {
      defaultMessage: 'Select sync job type to display.'
    }),
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.syncJobs.lastSync.tableSelector.name', {
      defaultMessage: 'Sync job type'
    }),
    idSelected: selectedSyncJobCategory,
    onChange: optionId => {
      setSelectedSyncJobCategory(optionId);
    },
    options: [{
      id: 'content',
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.syncJobs.lastSync.tableSelector.content.label', {
        defaultMessage: 'Content syncs'
      })
    }, {
      id: 'access_control',
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.syncJobs.lastSync.tableSelector.accessControl.label', {
        defaultMessage: 'Access control syncs'
      })
    }]
  }), selectedSyncJobCategory === 'content' ? /*#__PURE__*/_react.default.createElement(_sync_jobs_history_table.SyncJobsHistoryTable, {
    type: "content"
  }) : /*#__PURE__*/_react.default.createElement(_sync_jobs_history_table.SyncJobsHistoryTable, {
    type: "access_control"
  }));
};
exports.SyncJobs = SyncJobs;