"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextExpansionErrors = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _http = require("../../../../../shared/http");
var _telemetry = require("../../../../../shared/telemetry");
var _routes = require("../../../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TextExpansionErrors = ({
  error
}) => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
    action: "error",
    metric: "textExpansionModel-error"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "error",
    title: error.title
  }, /*#__PURE__*/_react.default.createElement("p", null, error.message), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: http.basePath.prepend(_routes.ML_NOTIFICATIONS_PATH),
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.textExpansionCreateError.mlNotificationsLink', {
    defaultMessage: 'Machine Learning notifications'
  }))));
};
exports.TextExpansionErrors = TextExpansionErrors;