"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTextExpansionCallOutData = exports.TEXT_EXPANSION_CALL_OUT_DISMISSED_KEY = void 0;
var _react = require("react");
var _kea = require("kea");
var _index_view_logic = require("../../index_view_logic");
var _text_expansion_callout_logic = require("./text_expansion_callout_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TEXT_EXPANSION_CALL_OUT_DISMISSED_KEY = 'enterprise-search-text-expansion-callout-dismissed';
exports.TEXT_EXPANSION_CALL_OUT_DISMISSED_KEY = TEXT_EXPANSION_CALL_OUT_DISMISSED_KEY;
const isDismissed = () => localStorage.getItem(TEXT_EXPANSION_CALL_OUT_DISMISSED_KEY) === 'true';
const useTextExpansionCallOutData = ({
  isCompact = false,
  isDismissable = false
}) => {
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    isCreateButtonDisabled,
    isModelRunningSingleThreaded,
    isStartButtonDisabled
  } = (0, _kea.useValues)(_text_expansion_callout_logic.TextExpansionCalloutLogic);
  const [show, setShow] = (0, _react.useState)(() => {
    if (!isDismissable) return true;
    try {
      return !isDismissed();
    } catch {
      return true;
    }
  });
  (0, _react.useEffect)(() => {
    try {
      if (!isDismissed()) {
        localStorage.setItem(TEXT_EXPANSION_CALL_OUT_DISMISSED_KEY, JSON.stringify(!show));
      }
    } catch {
      return;
    }
  }, [show]);
  const dismiss = (0, _react.useCallback)(() => {
    setShow(false);
  }, []);
  return {
    dismiss,
    ingestionMethod,
    isCompact,
    isCreateButtonDisabled,
    isDismissable,
    isSingleThreaded: isModelRunningSingleThreaded,
    isStartButtonDisabled,
    show
  };
};
exports.useTextExpansionCallOutData = useTextExpansionCallOutData;